# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.5
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class AdminApiUserDTO(BaseModel):
    """
    AdminApiUserDTO
    """
    id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    language: Optional[StrictStr] = None
    is_admin: Optional[StrictBool] = Field(default=None, alias="isAdmin")
    widgets_allowed: Optional[StrictBool] = Field(default=None, alias="widgetsAllowed")
    full_search_allowed: Optional[StrictBool] = Field(default=None, alias="fullSearchAllowed")
    voice_search_allowed: Optional[StrictBool] = Field(default=None, alias="voiceSearchAllowed")
    recording_detail_allowed: Optional[StrictBool] = Field(default=None, alias="recordingDetailAllowed")
    artist_detail_allowed: Optional[StrictBool] = Field(default=None, alias="artistDetailAllowed")
    playlist_prediction_allowed: Optional[StrictBool] = Field(default=None, alias="playlistPredictionAllowed")
    signup_allowed: Optional[StrictBool] = Field(default=None, alias="signupAllowed")
    upload_allowed: Optional[StrictBool] = Field(default=None, alias="uploadAllowed")
    fingerprint_allowed: Optional[StrictBool] = Field(default=None, alias="fingerprintAllowed")
    audiotagging_allowed: Optional[StrictBool] = Field(default=None, alias="audiotaggingAllowed")
    b2b_allowed: Optional[StrictBool] = Field(default=None, alias="b2bAllowed")
    editor_allowed: Optional[StrictBool] = Field(default=None, alias="editorAllowed")
    reduced_musical_features: Optional[StrictBool] = Field(default=None, alias="reducedMusicalFeatures")
    confirmed: Optional[StrictBool] = None
    gdpr_confirmation_timestamp: Optional[datetime] = Field(default=None, alias="gdprConfirmationTimestamp")
    last_login: Optional[datetime] = Field(default=None, alias="lastLogin")
    total_logins: Optional[StrictInt] = Field(default=None, alias="totalLogins")
    total_searches: Optional[StrictInt] = Field(default=None, alias="totalSearches")
    total_uploads: Optional[StrictInt] = Field(default=None, alias="totalUploads")
    total_downloads: Optional[StrictInt] = Field(default=None, alias="totalDownloads")
    total_updates: Optional[StrictInt] = Field(default=None, alias="totalUpdates")
    __properties: ClassVar[List[str]] = ["id", "username", "email", "fullName", "language", "isAdmin", "widgetsAllowed", "fullSearchAllowed", "voiceSearchAllowed", "recordingDetailAllowed", "artistDetailAllowed", "playlistPredictionAllowed", "signupAllowed", "uploadAllowed", "fingerprintAllowed", "audiotaggingAllowed", "b2bAllowed", "editorAllowed", "reducedMusicalFeatures", "confirmed", "gdprConfirmationTimestamp", "lastLogin", "totalLogins", "totalSearches", "totalUploads", "totalDownloads", "totalUpdates"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of AdminApiUserDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of AdminApiUserDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "fullName": obj.get("fullName"),
            "language": obj.get("language"),
            "isAdmin": obj.get("isAdmin"),
            "widgetsAllowed": obj.get("widgetsAllowed"),
            "fullSearchAllowed": obj.get("fullSearchAllowed"),
            "voiceSearchAllowed": obj.get("voiceSearchAllowed"),
            "recordingDetailAllowed": obj.get("recordingDetailAllowed"),
            "artistDetailAllowed": obj.get("artistDetailAllowed"),
            "playlistPredictionAllowed": obj.get("playlistPredictionAllowed"),
            "signupAllowed": obj.get("signupAllowed"),
            "uploadAllowed": obj.get("uploadAllowed"),
            "fingerprintAllowed": obj.get("fingerprintAllowed"),
            "audiotaggingAllowed": obj.get("audiotaggingAllowed"),
            "b2bAllowed": obj.get("b2bAllowed"),
            "editorAllowed": obj.get("editorAllowed"),
            "reducedMusicalFeatures": obj.get("reducedMusicalFeatures"),
            "confirmed": obj.get("confirmed"),
            "gdprConfirmationTimestamp": obj.get("gdprConfirmationTimestamp"),
            "lastLogin": obj.get("lastLogin"),
            "totalLogins": obj.get("totalLogins"),
            "totalSearches": obj.get("totalSearches"),
            "totalUploads": obj.get("totalUploads"),
            "totalDownloads": obj.get("totalDownloads"),
            "totalUpdates": obj.get("totalUpdates")
        })
        return _obj


