# Generated by Django 5.1.2 on 2024-10-28 16:40

import autoslug.fields
import django.db.models.deletion
import timezone_field.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('aviation', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Trip',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from='get_slug', unique_with=('start__year', 'start__month', 'start__day'))),
                ('name', models.CharField(max_length=64)),
                ('start', models.DateField()),
                ('end', models.DateField(blank=True, max_length=25, null=True)),
                ('open_location_code', models.CharField(blank=True, max_length=25, null=True)),
            ],
            options={
                'unique_together': {('start', 'slug')},
            },
        ),
        migrations.CreateModel(
            name='Flight',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from='get_slug', unique_with=('departure__year', 'departure__month', 'departure__day'))),
                ('departure', models.DateTimeField()),
                ('flight_number', models.CharField(max_length=6)),
                ('arrival_timezone', timezone_field.fields.TimeZoneField()),
                ('arrival', models.DateTimeField(max_length=25)),
                ('departure_timezone', timezone_field.fields.TimeZoneField()),
                ('destination_city', models.CharField(max_length=255)),
                ('destination_gate', models.CharField(blank=True, max_length=255, null=True)),
                ('destination_terminal', models.CharField(blank=True, max_length=255, null=True)),
                ('flight_class', models.CharField(blank=True, max_length=255, null=True)),
                ('origin_city', models.CharField(max_length=255)),
                ('origin_gate', models.CharField(blank=True, max_length=255, null=True)),
                ('origin_terminal', models.CharField(blank=True, max_length=255, null=True)),
                ('passenger', models.CharField(blank=True, max_length=255, null=True)),
                ('seat', models.CharField(blank=True, max_length=3, null=True)),
                ('sequence_number', models.CharField(max_length=3)),
                ('airline', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flights', to='aviation.airline')),
                ('destination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='destination_flights', to='aviation.airport')),
                ('origin', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='originating_flights', to='aviation.airport')),
                ('trip', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flights', to='air_transport.trip')),
            ],
            options={
                'unique_together': {('departure', 'flight_number')},
            },
        ),
    ]
