/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as sfn from '@aws-cdk/aws-stepfunctions';
import * as events from '@aws-cdk/aws-events';
import { Construct } from '@aws-cdk/core';
import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as logs from '@aws-cdk/aws-logs';
/**
 * @summary The properties for the EventsRuleToStepFunction Construct
 */
export interface EventsRuleToStepFunctionProps {
    /**
     * Existing instance of a custom EventBus.
     *
     * @default - None
     */
    readonly existingEventBusInterface?: events.IEventBus;
    /**
     * A new custom EventBus is created with provided props.
     *
     * @default - None
     */
    readonly eventBusProps?: events.EventBusProps;
    /**
     * User provided StateMachineProps to override the defaults
     *
     * @default - None
     */
    readonly stateMachineProps: sfn.StateMachineProps;
    /**
     * User provided eventRuleProps to override the defaults
     *
     * @default - None
     */
    readonly eventRuleProps: events.RuleProps;
    /**
     * Whether to create recommended CloudWatch alarms
     *
     * @default - Alarms are created
     */
    readonly createCloudWatchAlarms?: boolean;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
}
export declare class EventsRuleToStepFunction extends Construct {
    readonly stateMachine: sfn.StateMachine;
    readonly stateMachineLogGroup: logs.ILogGroup;
    readonly eventsRule: events.Rule;
    readonly cloudwatchAlarms?: cloudwatch.Alarm[];
    readonly eventBus?: events.IEventBus;
    /**
     * @summary Constructs a new instance of the EventsRuleToStepFunction class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventsRuleToStepFunctionProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope: Construct, id: string, props: EventsRuleToStepFunctionProps);
}
