"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListProfilesRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""


class ListProfilesRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit"]
        nullable_fields = ["limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListProfilesBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListProfilesBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListProfilesBadRequestLinksTypedDict(TypedDict):
    documentation: ListProfilesBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListProfilesBadRequestLinks(BaseModel):
    documentation: ListProfilesBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListProfilesHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListProfilesBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListProfilesHalJSONError(ClientError):
    r"""An error response object."""

    data: ListProfilesHalJSONErrorData

    def __init__(
        self,
        data: ListProfilesHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListProfilesMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListProfilesStatus(str, Enum):
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    UNVERIFIED = "unverified"
    VERIFIED = "verified"
    BLOCKED = "blocked"


class ListProfilesReviewStatus(str, Enum):
    r"""The status of the requested changes."""

    PENDING = "pending"
    REJECTED = "rejected"


class ListProfilesReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: NotRequired[ListProfilesReviewStatus]
    r"""The status of the requested changes."""


class ListProfilesReview(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: Optional[ListProfilesReviewStatus] = None
    r"""The status of the requested changes."""


class ProfileSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ProfileSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesDashboardTypedDict(TypedDict):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesDashboard(BaseModel):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesChargebacks(BaseModel):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesMethodsTypedDict(TypedDict):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesMethods(BaseModel):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesPayments(BaseModel):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesRefundsTypedDict(TypedDict):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesRefunds(BaseModel):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesCheckoutPreviewURLTypedDict(TypedDict):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesCheckoutPreviewURL(BaseModel):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ProfileDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ProfileDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ProfileLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ProfileSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[ListProfilesDashboardTypedDict]
    r"""Link to the profile in the Mollie dashboard."""
    chargebacks: NotRequired[ListProfilesChargebacksTypedDict]
    r"""The API resource URL of the chargebacks that belong to this profile."""
    methods: NotRequired[ListProfilesMethodsTypedDict]
    r"""The API resource URL of the methods that are enabled for this profile."""
    payments: NotRequired[ListProfilesPaymentsTypedDict]
    r"""The API resource URL of the payments that belong to this profile."""
    refunds: NotRequired[ListProfilesRefundsTypedDict]
    r"""The API resource URL of the refunds that belong to this profile."""
    checkout_preview_url: NotRequired[ListProfilesCheckoutPreviewURLTypedDict]
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""
    documentation: NotRequired[ProfileDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ProfileLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ProfileSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[ListProfilesDashboard] = None
    r"""Link to the profile in the Mollie dashboard."""

    chargebacks: Optional[ListProfilesChargebacks] = None
    r"""The API resource URL of the chargebacks that belong to this profile."""

    methods: Optional[ListProfilesMethods] = None
    r"""The API resource URL of the methods that are enabled for this profile."""

    payments: Optional[ListProfilesPayments] = None
    r"""The API resource URL of the payments that belong to this profile."""

    refunds: Optional[ListProfilesRefunds] = None
    r"""The API resource URL of the refunds that belong to this profile."""

    checkout_preview_url: Annotated[
        Optional[ListProfilesCheckoutPreviewURL],
        pydantic.Field(alias="checkoutPreviewUrl"),
    ] = None
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    documentation: Optional[ProfileDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListProfilesProfileTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: NotRequired[ListProfilesMode]
    r"""Whether this entity was created in live mode or in test mode."""
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """
    status: NotRequired[ListProfilesStatus]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """
    review: NotRequired[ListProfilesReviewTypedDict]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[ProfileLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListProfilesProfile(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Optional[ListProfilesMode] = None
    r"""Whether this entity was created in live mode or in test mode."""

    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """

    status: Optional[ListProfilesStatus] = None
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    review: Optional[ListProfilesReview] = None
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[ProfileLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListProfilesEmbeddedTypedDict(TypedDict):
    profiles: NotRequired[List[ListProfilesProfileTypedDict]]
    r"""An array of profile objects."""


class ListProfilesEmbedded(BaseModel):
    profiles: Optional[List[ListProfilesProfile]] = None
    r"""An array of profile objects."""


class ListProfilesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListProfilesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListProfilesSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListProfilesPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListProfilesNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListProfilesDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListProfilesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListProfilesSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListProfilesPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListProfilesNext]
    r"""The next set of items, if available."""

    documentation: ListProfilesDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListProfilesResponseTypedDict(TypedDict):
    r"""A list of profile objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListProfilesEmbeddedTypedDict]
    links: NotRequired[ListProfilesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListProfilesResponse(BaseModel):
    r"""A list of profile objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListProfilesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListProfilesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
