import { SdkError } from "@aws-sdk/types";
export interface RetryDecider {
  (error: SdkError): boolean;
}
export interface DelayDecider {
  (delayBase: number, attempts: number): number;
}
export interface RetryQuota {
  hasRetryTokens: (error: SdkError) => boolean;
  retrieveRetryTokens: (error: SdkError) => number;
  releaseRetryTokens: (releaseCapacityAmount?: number) => void;
}
export interface RateLimiter {
  getSendToken: () => Promise<void>;
  updateClientSendingRate: (response: any) => void;
}
