# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rockset.swagger_client.api_client import ApiClient


class ViewsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, workspace, body, **kwargs):  # noqa: E501
        """Create View  # noqa: E501

        Create a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(workspace, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param CreateViewRequest body: JSON object (required)
        :return: CreateViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(workspace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(workspace, body, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, workspace, body, **kwargs):  # noqa: E501
        """Create View  # noqa: E501

        Create a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_with_http_info(workspace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param CreateViewRequest body: JSON object (required)
        :return: CreateViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `create`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/views', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateViewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, workspace, view, **kwargs):  # noqa: E501
        """Delete View  # noqa: E501

        Delete a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(workspace, view, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :return: DeleteViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(workspace, view, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(workspace, view, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, workspace, view, **kwargs):  # noqa: E501
        """Delete View  # noqa: E501

        Delete a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_with_http_info(workspace, view, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :return: DeleteViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'view']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `delete`")  # noqa: E501
        # verify the required parameter 'view' is set
        if ('view' not in params or
                params['view'] is None):
            raise ValueError("Missing the required parameter `view` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'view' in params:
            path_params['view'] = params['view']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/views/{view}', 'DELETE',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteViewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get(self, workspace, view, **kwargs):  # noqa: E501
        """Retrieve View  # noqa: E501

        Get details about a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get(workspace, view, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :return: GetViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_with_http_info(workspace, view, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(workspace, view, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, workspace, view, **kwargs):  # noqa: E501
        """Retrieve View  # noqa: E501

        Get details about a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_with_http_info(workspace, view, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :return: GetViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'view']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `get`")  # noqa: E501
        # verify the required parameter 'view' is set
        if ('view' not in params or
                params['view'] is None):
            raise ValueError("Missing the required parameter `view` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'view' in params:
            path_params['view'] = params['view']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/views/{view}', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetViewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List Views  # noqa: E501

        Retrieve all views in an organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListViewsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List Views  # noqa: E501

        Retrieve all views in an organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListViewsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/views', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListViewsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, workspace, view, body, **kwargs):  # noqa: E501
        """Update View  # noqa: E501

        Update a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(workspace, view, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :param UpdateViewRequest body: JSON object (required)
        :return: UpdateViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(workspace, view, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(workspace, view, body, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, workspace, view, body, **kwargs):  # noqa: E501
        """Update View  # noqa: E501

        Update a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_with_http_info(workspace, view, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str view: name of the view (required)
        :param UpdateViewRequest body: JSON object (required)
        :return: UpdateViewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'view', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `update`")  # noqa: E501
        # verify the required parameter 'view' is set
        if ('view' not in params or
                params['view'] is None):
            raise ValueError("Missing the required parameter `view` when calling `update`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'view' in params:
            path_params['view'] = params['view']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/views/{view}', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateViewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workspace(self, workspace, **kwargs):  # noqa: E501
        """List Views in Workspace  # noqa: E501

        Retrieve all views in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workspace(workspace, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :return: ListViewsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workspace_with_http_info(workspace, **kwargs)  # noqa: E501
        else:
            (data) = self.workspace_with_http_info(workspace, **kwargs)  # noqa: E501
            return data

    def workspace_with_http_info(self, workspace, **kwargs):  # noqa: E501
        """List Views in Workspace  # noqa: E501

        Retrieve all views in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.workspace_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :return: ListViewsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/views', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListViewsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
