# coding: utf-8

# flake8: noqa
"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from rockset.swagger_client.models.add_documents_request import AddDocumentsRequest
from rockset.swagger_client.models.add_documents_response import AddDocumentsResponse
from rockset.swagger_client.models.alias import Alias
from rockset.swagger_client.models.api_key import ApiKey
from rockset.swagger_client.models.aws_access_key import AwsAccessKey
from rockset.swagger_client.models.aws_role import AwsRole
from rockset.swagger_client.models.collection import Collection
from rockset.swagger_client.models.collection_stats import CollectionStats
from rockset.swagger_client.models.create_alias_request import CreateAliasRequest
from rockset.swagger_client.models.create_alias_response import CreateAliasResponse
from rockset.swagger_client.models.create_api_key_request import CreateApiKeyRequest
from rockset.swagger_client.models.create_api_key_response import CreateApiKeyResponse
from rockset.swagger_client.models.create_collection_request import CreateCollectionRequest
from rockset.swagger_client.models.create_collection_response import CreateCollectionResponse
from rockset.swagger_client.models.create_integration_request import CreateIntegrationRequest
from rockset.swagger_client.models.create_integration_response import CreateIntegrationResponse
from rockset.swagger_client.models.create_query_lambda_request import CreateQueryLambdaRequest
from rockset.swagger_client.models.create_query_lambda_tag_request import CreateQueryLambdaTagRequest
from rockset.swagger_client.models.create_role_request import CreateRoleRequest
from rockset.swagger_client.models.create_user_request import CreateUserRequest
from rockset.swagger_client.models.create_user_response import CreateUserResponse
from rockset.swagger_client.models.create_view_request import CreateViewRequest
from rockset.swagger_client.models.create_view_response import CreateViewResponse
from rockset.swagger_client.models.create_workspace_request import CreateWorkspaceRequest
from rockset.swagger_client.models.create_workspace_response import CreateWorkspaceResponse
from rockset.swagger_client.models.csv_params import CsvParams
from rockset.swagger_client.models.delete_alias_response import DeleteAliasResponse
from rockset.swagger_client.models.delete_api_key_response import DeleteApiKeyResponse
from rockset.swagger_client.models.delete_collection_response import DeleteCollectionResponse
from rockset.swagger_client.models.delete_documents_request import DeleteDocumentsRequest
from rockset.swagger_client.models.delete_documents_request_data import DeleteDocumentsRequestData
from rockset.swagger_client.models.delete_documents_response import DeleteDocumentsResponse
from rockset.swagger_client.models.delete_integration_response import DeleteIntegrationResponse
from rockset.swagger_client.models.delete_query_lambda_response import DeleteQueryLambdaResponse
from rockset.swagger_client.models.delete_user_response import DeleteUserResponse
from rockset.swagger_client.models.delete_view_response import DeleteViewResponse
from rockset.swagger_client.models.delete_workspace_response import DeleteWorkspaceResponse
from rockset.swagger_client.models.document_status import DocumentStatus
from rockset.swagger_client.models.dynamodb_integration import DynamodbIntegration
from rockset.swagger_client.models.error_model import ErrorModel
from rockset.swagger_client.models.event_time_info import EventTimeInfo
from rockset.swagger_client.models.execute_query_lambda_request import ExecuteQueryLambdaRequest
from rockset.swagger_client.models.field_mapping import FieldMapping
from rockset.swagger_client.models.field_mapping_query import FieldMappingQuery
from rockset.swagger_client.models.field_mapping_v2 import FieldMappingV2
from rockset.swagger_client.models.field_mask import FieldMask
from rockset.swagger_client.models.field_mask_mask import FieldMaskMask
from rockset.swagger_client.models.field_options import FieldOptions
from rockset.swagger_client.models.field_partition import FieldPartition
from rockset.swagger_client.models.field_schema import FieldSchema
from rockset.swagger_client.models.format_params import FormatParams
from rockset.swagger_client.models.gcp_service_account import GcpServiceAccount
from rockset.swagger_client.models.gcs_integration import GcsIntegration
from rockset.swagger_client.models.get_alias_response import GetAliasResponse
from rockset.swagger_client.models.get_api_key_response import GetApiKeyResponse
from rockset.swagger_client.models.get_collection_response import GetCollectionResponse
from rockset.swagger_client.models.get_integration_response import GetIntegrationResponse
from rockset.swagger_client.models.get_view_response import GetViewResponse
from rockset.swagger_client.models.get_virtual_instance_response import GetVirtualInstanceResponse
from rockset.swagger_client.models.get_workspace_response import GetWorkspaceResponse
from rockset.swagger_client.models.input_field import InputField
from rockset.swagger_client.models.integration import Integration
from rockset.swagger_client.models.inverted_index_group_encoding_options import InvertedIndexGroupEncodingOptions
from rockset.swagger_client.models.kafka_integration import KafkaIntegration
from rockset.swagger_client.models.kafka_v3_security_config import KafkaV3SecurityConfig
from rockset.swagger_client.models.kinesis_integration import KinesisIntegration
from rockset.swagger_client.models.list_aliases_response import ListAliasesResponse
from rockset.swagger_client.models.list_api_keys_response import ListApiKeysResponse
from rockset.swagger_client.models.list_collections_response import ListCollectionsResponse
from rockset.swagger_client.models.list_integrations_response import ListIntegrationsResponse
from rockset.swagger_client.models.list_query_lambda_tags_response import ListQueryLambdaTagsResponse
from rockset.swagger_client.models.list_query_lambda_versions_response import ListQueryLambdaVersionsResponse
from rockset.swagger_client.models.list_query_lambdas_response import ListQueryLambdasResponse
from rockset.swagger_client.models.list_roles_response import ListRolesResponse
from rockset.swagger_client.models.list_unsubscribe_preferences_response import ListUnsubscribePreferencesResponse
from rockset.swagger_client.models.list_users_response import ListUsersResponse
from rockset.swagger_client.models.list_views_response import ListViewsResponse
from rockset.swagger_client.models.list_virtual_instances_response import ListVirtualInstancesResponse
from rockset.swagger_client.models.list_workspaces_response import ListWorkspacesResponse
from rockset.swagger_client.models.mongo_db_integration import MongoDbIntegration
from rockset.swagger_client.models.organization import Organization
from rockset.swagger_client.models.organization_response import OrganizationResponse
from rockset.swagger_client.models.output_field import OutputField
from rockset.swagger_client.models.pagination_info import PaginationInfo
from rockset.swagger_client.models.patch_document import PatchDocument
from rockset.swagger_client.models.patch_documents_request import PatchDocumentsRequest
from rockset.swagger_client.models.patch_documents_response import PatchDocumentsResponse
from rockset.swagger_client.models.patch_operation import PatchOperation
from rockset.swagger_client.models.privilege import Privilege
from rockset.swagger_client.models.query_error import QueryError
from rockset.swagger_client.models.query_field_type import QueryFieldType
from rockset.swagger_client.models.query_lambda import QueryLambda
from rockset.swagger_client.models.query_lambda_sql import QueryLambdaSql
from rockset.swagger_client.models.query_lambda_stats import QueryLambdaStats
from rockset.swagger_client.models.query_lambda_tag import QueryLambdaTag
from rockset.swagger_client.models.query_lambda_tag_response import QueryLambdaTagResponse
from rockset.swagger_client.models.query_lambda_version import QueryLambdaVersion
from rockset.swagger_client.models.query_lambda_version_response import QueryLambdaVersionResponse
from rockset.swagger_client.models.query_parameter import QueryParameter
from rockset.swagger_client.models.query_request import QueryRequest
from rockset.swagger_client.models.query_request_sql import QueryRequestSql
from rockset.swagger_client.models.query_response import QueryResponse
from rockset.swagger_client.models.query_response_stats import QueryResponseStats
from rockset.swagger_client.models.redshift_integration import RedshiftIntegration
from rockset.swagger_client.models.role import Role
from rockset.swagger_client.models.role_response import RoleResponse
from rockset.swagger_client.models.s3_integration import S3Integration
from rockset.swagger_client.models.segment_integration import SegmentIntegration
from rockset.swagger_client.models.source import Source
from rockset.swagger_client.models.source_dynamo_db import SourceDynamoDb
from rockset.swagger_client.models.source_file_upload import SourceFileUpload
from rockset.swagger_client.models.source_gcs import SourceGcs
from rockset.swagger_client.models.source_kafka import SourceKafka
from rockset.swagger_client.models.source_kinesis import SourceKinesis
from rockset.swagger_client.models.source_mongo_db import SourceMongoDb
from rockset.swagger_client.models.source_redshift import SourceRedshift
from rockset.swagger_client.models.source_s3 import SourceS3
from rockset.swagger_client.models.sql_expression import SqlExpression
from rockset.swagger_client.models.status import Status
from rockset.swagger_client.models.status_dynamo_db import StatusDynamoDb
from rockset.swagger_client.models.status_dynamo_db_v2 import StatusDynamoDbV2
from rockset.swagger_client.models.status_kafka import StatusKafka
from rockset.swagger_client.models.status_kafka_partition import StatusKafkaPartition
from rockset.swagger_client.models.status_mongo_db import StatusMongoDb
from rockset.swagger_client.models.unsubscribe_preference import UnsubscribePreference
from rockset.swagger_client.models.update_alias_request import UpdateAliasRequest
from rockset.swagger_client.models.update_api_key_request import UpdateApiKeyRequest
from rockset.swagger_client.models.update_api_key_response import UpdateApiKeyResponse
from rockset.swagger_client.models.update_query_lambda_request import UpdateQueryLambdaRequest
from rockset.swagger_client.models.update_role_request import UpdateRoleRequest
from rockset.swagger_client.models.update_unsubscribe_preferences_request import UpdateUnsubscribePreferencesRequest
from rockset.swagger_client.models.update_unsubscribe_preferences_response import UpdateUnsubscribePreferencesResponse
from rockset.swagger_client.models.update_view_request import UpdateViewRequest
from rockset.swagger_client.models.update_view_response import UpdateViewResponse
from rockset.swagger_client.models.update_virtual_instance_request import UpdateVirtualInstanceRequest
from rockset.swagger_client.models.update_virtual_instance_response import UpdateVirtualInstanceResponse
from rockset.swagger_client.models.user import User
from rockset.swagger_client.models.validate_query_response import ValidateQueryResponse
from rockset.swagger_client.models.view import View
from rockset.swagger_client.models.virtual_instance import VirtualInstance
from rockset.swagger_client.models.workspace import Workspace
from rockset.swagger_client.models.xml_params import XmlParams
