# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ApiKey(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'str',
        'name': 'str',
        'key': 'str',
        'last_access_time': 'str',
        'role': 'str',
        'created_by': 'str',
        'state': 'str'
    }

    attribute_map = {
        'created_at': 'created_at',
        'name': 'name',
        'key': 'key',
        'last_access_time': 'last_access_time',
        'role': 'role',
        'created_by': 'created_by',
        'state': 'state'
    }

    def __init__(self, name, key, **kwargs):  # noqa: E501
        """ApiKey - a model defined in Swagger"""  # noqa: E501

        self._created_at = None
        self._name = None
        self._key = None
        self._last_access_time = None
        self._role = None
        self._created_by = None
        self._state = None
        self.discriminator = None

        self.created_at = kwargs.pop('created_at', None)
        self.name = name
        self.key = key
        self.last_access_time = kwargs.pop('last_access_time', None)
        self.role = kwargs.pop('role', None)
        self.created_by = kwargs.pop('created_by', None)
        self.state = kwargs.pop('state', None)

    @property
    def created_at(self):
        """Gets the created_at of this ApiKey.  # noqa: E501

        Date that API key was created (ISO-8601 format).  # noqa: E501

        :return: The created_at of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ApiKey.

        Date that API key was created (ISO-8601 format).  # noqa: E501

        :param created_at: The created_at of this ApiKey.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def name(self):
        """Gets the name of this ApiKey.  # noqa: E501

        Name of the API key.  # noqa: E501

        :return: The name of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApiKey.

        Name of the API key.  # noqa: E501

        :param name: The name of this ApiKey.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def key(self):
        """Gets the key of this ApiKey.  # noqa: E501

        API key string of 64 alphanumeric characters.  # noqa: E501

        :return: The key of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this ApiKey.

        API key string of 64 alphanumeric characters.  # noqa: E501

        :param key: The key of this ApiKey.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def last_access_time(self):
        """Gets the last_access_time of this ApiKey.  # noqa: E501

        Date that API key was most recently used (ISO-8601 format).  # noqa: E501

        :return: The last_access_time of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._last_access_time

    @last_access_time.setter
    def last_access_time(self, last_access_time):
        """Sets the last_access_time of this ApiKey.

        Date that API key was most recently used (ISO-8601 format).  # noqa: E501

        :param last_access_time: The last_access_time of this ApiKey.  # noqa: E501
        :type: str
        """

        self._last_access_time = last_access_time

    @property
    def role(self):
        """Gets the role of this ApiKey.  # noqa: E501


        :return: The role of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this ApiKey.


        :param role: The role of this ApiKey.  # noqa: E501
        :type: str
        """

        self._role = role

    @property
    def created_by(self):
        """Gets the created_by of this ApiKey.  # noqa: E501

        Email of API key owner.  # noqa: E501

        :return: The created_by of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this ApiKey.

        Email of API key owner.  # noqa: E501

        :param created_by: The created_by of this ApiKey.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def state(self):
        """Gets the state of this ApiKey.  # noqa: E501

        current state of this key  # noqa: E501

        :return: The state of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ApiKey.

        current state of this key  # noqa: E501

        :param state: The state of this ApiKey.  # noqa: E501
        :type: str
        """

        self._state = state

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ApiKey, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
