# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.dynamodb_integration import DynamodbIntegration  # noqa: F401,E501
from rockset.swagger_client.models.gcs_integration import GcsIntegration  # noqa: F401,E501
from rockset.swagger_client.models.kafka_integration import KafkaIntegration  # noqa: F401,E501
from rockset.swagger_client.models.kinesis_integration import KinesisIntegration  # noqa: F401,E501
from rockset.swagger_client.models.mongo_db_integration import MongoDbIntegration  # noqa: F401,E501
from rockset.swagger_client.models.redshift_integration import RedshiftIntegration  # noqa: F401,E501
from rockset.swagger_client.models.s3_integration import S3Integration  # noqa: F401,E501
from rockset.swagger_client.models.segment_integration import SegmentIntegration  # noqa: F401,E501


class CreateIntegrationRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        's3': 'S3Integration',
        'kinesis': 'KinesisIntegration',
        'dynamodb': 'DynamodbIntegration',
        'redshift': 'RedshiftIntegration',
        'gcs': 'GcsIntegration',
        'segment': 'SegmentIntegration',
        'kafka': 'KafkaIntegration',
        'mongodb': 'MongoDbIntegration'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        's3': 's3',
        'kinesis': 'kinesis',
        'dynamodb': 'dynamodb',
        'redshift': 'redshift',
        'gcs': 'gcs',
        'segment': 'segment',
        'kafka': 'kafka',
        'mongodb': 'mongodb'
    }

    def __init__(self, name, **kwargs):  # noqa: E501
        """CreateIntegrationRequest - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._description = None
        self._s3 = None
        self._kinesis = None
        self._dynamodb = None
        self._redshift = None
        self._gcs = None
        self._segment = None
        self._kafka = None
        self._mongodb = None
        self.discriminator = None

        self.name = name
        self.description = kwargs.pop('description', None)
        self.s3 = kwargs.pop('s3', None)
        self.kinesis = kwargs.pop('kinesis', None)
        self.dynamodb = kwargs.pop('dynamodb', None)
        self.redshift = kwargs.pop('redshift', None)
        self.gcs = kwargs.pop('gcs', None)
        self.segment = kwargs.pop('segment', None)
        self.kafka = kwargs.pop('kafka', None)
        self.mongodb = kwargs.pop('mongodb', None)

    @property
    def name(self):
        """Gets the name of this CreateIntegrationRequest.  # noqa: E501

        descriptive label  # noqa: E501

        :return: The name of this CreateIntegrationRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateIntegrationRequest.

        descriptive label  # noqa: E501

        :param name: The name of this CreateIntegrationRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this CreateIntegrationRequest.  # noqa: E501

        longer explanation for the integration  # noqa: E501

        :return: The description of this CreateIntegrationRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateIntegrationRequest.

        longer explanation for the integration  # noqa: E501

        :param description: The description of this CreateIntegrationRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def s3(self):
        """Gets the s3 of this CreateIntegrationRequest.  # noqa: E501

        Amazon S3 details, must have one of aws_access_key or aws_role  # noqa: E501

        :return: The s3 of this CreateIntegrationRequest.  # noqa: E501
        :rtype: S3Integration
        """
        return self._s3

    @s3.setter
    def s3(self, s3):
        """Sets the s3 of this CreateIntegrationRequest.

        Amazon S3 details, must have one of aws_access_key or aws_role  # noqa: E501

        :param s3: The s3 of this CreateIntegrationRequest.  # noqa: E501
        :type: S3Integration
        """

        self._s3 = s3

    @property
    def kinesis(self):
        """Gets the kinesis of this CreateIntegrationRequest.  # noqa: E501

        Amazon Kinesis details, must have one of aws_access_key or aws_role  # noqa: E501

        :return: The kinesis of this CreateIntegrationRequest.  # noqa: E501
        :rtype: KinesisIntegration
        """
        return self._kinesis

    @kinesis.setter
    def kinesis(self, kinesis):
        """Sets the kinesis of this CreateIntegrationRequest.

        Amazon Kinesis details, must have one of aws_access_key or aws_role  # noqa: E501

        :param kinesis: The kinesis of this CreateIntegrationRequest.  # noqa: E501
        :type: KinesisIntegration
        """

        self._kinesis = kinesis

    @property
    def dynamodb(self):
        """Gets the dynamodb of this CreateIntegrationRequest.  # noqa: E501

        Amazon DynamoDB details, must have one of aws_access_key or aws_role  # noqa: E501

        :return: The dynamodb of this CreateIntegrationRequest.  # noqa: E501
        :rtype: DynamodbIntegration
        """
        return self._dynamodb

    @dynamodb.setter
    def dynamodb(self, dynamodb):
        """Sets the dynamodb of this CreateIntegrationRequest.

        Amazon DynamoDB details, must have one of aws_access_key or aws_role  # noqa: E501

        :param dynamodb: The dynamodb of this CreateIntegrationRequest.  # noqa: E501
        :type: DynamodbIntegration
        """

        self._dynamodb = dynamodb

    @property
    def redshift(self):
        """Gets the redshift of this CreateIntegrationRequest.  # noqa: E501

        Amazon Redshift details  # noqa: E501

        :return: The redshift of this CreateIntegrationRequest.  # noqa: E501
        :rtype: RedshiftIntegration
        """
        return self._redshift

    @redshift.setter
    def redshift(self, redshift):
        """Sets the redshift of this CreateIntegrationRequest.

        Amazon Redshift details  # noqa: E501

        :param redshift: The redshift of this CreateIntegrationRequest.  # noqa: E501
        :type: RedshiftIntegration
        """

        self._redshift = redshift

    @property
    def gcs(self):
        """Gets the gcs of this CreateIntegrationRequest.  # noqa: E501

        GCS details  # noqa: E501

        :return: The gcs of this CreateIntegrationRequest.  # noqa: E501
        :rtype: GcsIntegration
        """
        return self._gcs

    @gcs.setter
    def gcs(self, gcs):
        """Sets the gcs of this CreateIntegrationRequest.

        GCS details  # noqa: E501

        :param gcs: The gcs of this CreateIntegrationRequest.  # noqa: E501
        :type: GcsIntegration
        """

        self._gcs = gcs

    @property
    def segment(self):
        """Gets the segment of this CreateIntegrationRequest.  # noqa: E501


        :return: The segment of this CreateIntegrationRequest.  # noqa: E501
        :rtype: SegmentIntegration
        """
        return self._segment

    @segment.setter
    def segment(self, segment):
        """Sets the segment of this CreateIntegrationRequest.


        :param segment: The segment of this CreateIntegrationRequest.  # noqa: E501
        :type: SegmentIntegration
        """

        self._segment = segment

    @property
    def kafka(self):
        """Gets the kafka of this CreateIntegrationRequest.  # noqa: E501


        :return: The kafka of this CreateIntegrationRequest.  # noqa: E501
        :rtype: KafkaIntegration
        """
        return self._kafka

    @kafka.setter
    def kafka(self, kafka):
        """Sets the kafka of this CreateIntegrationRequest.


        :param kafka: The kafka of this CreateIntegrationRequest.  # noqa: E501
        :type: KafkaIntegration
        """

        self._kafka = kafka

    @property
    def mongodb(self):
        """Gets the mongodb of this CreateIntegrationRequest.  # noqa: E501

        MongoDb details  # noqa: E501

        :return: The mongodb of this CreateIntegrationRequest.  # noqa: E501
        :rtype: MongoDbIntegration
        """
        return self._mongodb

    @mongodb.setter
    def mongodb(self, mongodb):
        """Sets the mongodb of this CreateIntegrationRequest.

        MongoDb details  # noqa: E501

        :param mongodb: The mongodb of this CreateIntegrationRequest.  # noqa: E501
        :type: MongoDbIntegration
        """

        self._mongodb = mongodb

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateIntegrationRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateIntegrationRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
