# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class InvertedIndexGroupEncodingOptions(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'format_version': 'int',
        'group_size': 'int',
        'restart_length': 'int',
        'event_time_codec': 'str',
        'doc_id_codec': 'str'
    }

    attribute_map = {
        'format_version': 'format_version',
        'group_size': 'group_size',
        'restart_length': 'restart_length',
        'event_time_codec': 'event_time_codec',
        'doc_id_codec': 'doc_id_codec'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """InvertedIndexGroupEncodingOptions - a model defined in Swagger"""  # noqa: E501

        self._format_version = None
        self._group_size = None
        self._restart_length = None
        self._event_time_codec = None
        self._doc_id_codec = None
        self.discriminator = None

        self.format_version = kwargs.pop('format_version', None)
        self.group_size = kwargs.pop('group_size', None)
        self.restart_length = kwargs.pop('restart_length', None)
        self.event_time_codec = kwargs.pop('event_time_codec', None)
        self.doc_id_codec = kwargs.pop('doc_id_codec', None)

    @property
    def format_version(self):
        """Gets the format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._format_version

    @format_version.setter
    def format_version(self, format_version):
        """Sets the format_version of this InvertedIndexGroupEncodingOptions.


        :param format_version: The format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type: int
        """

        self._format_version = format_version

    @property
    def group_size(self):
        """Gets the group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._group_size

    @group_size.setter
    def group_size(self, group_size):
        """Sets the group_size of this InvertedIndexGroupEncodingOptions.


        :param group_size: The group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type: int
        """

        self._group_size = group_size

    @property
    def restart_length(self):
        """Gets the restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._restart_length

    @restart_length.setter
    def restart_length(self, restart_length):
        """Sets the restart_length of this InvertedIndexGroupEncodingOptions.


        :param restart_length: The restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type: int
        """

        self._restart_length = restart_length

    @property
    def event_time_codec(self):
        """Gets the event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: str
        """
        return self._event_time_codec

    @event_time_codec.setter
    def event_time_codec(self, event_time_codec):
        """Sets the event_time_codec of this InvertedIndexGroupEncodingOptions.


        :param event_time_codec: The event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type: str
        """

        self._event_time_codec = event_time_codec

    @property
    def doc_id_codec(self):
        """Gets the doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: str
        """
        return self._doc_id_codec

    @doc_id_codec.setter
    def doc_id_codec(self, doc_id_codec):
        """Sets the doc_id_codec of this InvertedIndexGroupEncodingOptions.


        :param doc_id_codec: The doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type: str
        """

        self._doc_id_codec = doc_id_codec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InvertedIndexGroupEncodingOptions, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvertedIndexGroupEncodingOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
