# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PaginationInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'current_page_doc_count': 'int',
        'next_cursor_offset': 'int',
        'start_cursor': 'str',
        'next_cursor': 'str'
    }

    attribute_map = {
        'current_page_doc_count': 'current_page_doc_count',
        'next_cursor_offset': 'next_cursor_offset',
        'start_cursor': 'start_cursor',
        'next_cursor': 'next_cursor'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """PaginationInfo - a model defined in Swagger"""  # noqa: E501

        self._current_page_doc_count = None
        self._next_cursor_offset = None
        self._start_cursor = None
        self._next_cursor = None
        self.discriminator = None

        self.current_page_doc_count = kwargs.pop('current_page_doc_count', None)
        self.next_cursor_offset = kwargs.pop('next_cursor_offset', None)
        self.start_cursor = kwargs.pop('start_cursor', None)
        self.next_cursor = kwargs.pop('next_cursor', None)

    @property
    def current_page_doc_count(self):
        """Gets the current_page_doc_count of this PaginationInfo.  # noqa: E501

        Number of documents returned in this result set  # noqa: E501

        :return: The current_page_doc_count of this PaginationInfo.  # noqa: E501
        :rtype: int
        """
        return self._current_page_doc_count

    @current_page_doc_count.setter
    def current_page_doc_count(self, current_page_doc_count):
        """Sets the current_page_doc_count of this PaginationInfo.

        Number of documents returned in this result set  # noqa: E501

        :param current_page_doc_count: The current_page_doc_count of this PaginationInfo.  # noqa: E501
        :type: int
        """

        self._current_page_doc_count = current_page_doc_count

    @property
    def next_cursor_offset(self):
        """Gets the next_cursor_offset of this PaginationInfo.  # noqa: E501

        The doc offset that next_cursor starts at.  # noqa: E501

        :return: The next_cursor_offset of this PaginationInfo.  # noqa: E501
        :rtype: int
        """
        return self._next_cursor_offset

    @next_cursor_offset.setter
    def next_cursor_offset(self, next_cursor_offset):
        """Sets the next_cursor_offset of this PaginationInfo.

        The doc offset that next_cursor starts at.  # noqa: E501

        :param next_cursor_offset: The next_cursor_offset of this PaginationInfo.  # noqa: E501
        :type: int
        """

        self._next_cursor_offset = next_cursor_offset

    @property
    def start_cursor(self):
        """Gets the start_cursor of this PaginationInfo.  # noqa: E501

        Cursor used to retrieve the first set of documents.  # noqa: E501

        :return: The start_cursor of this PaginationInfo.  # noqa: E501
        :rtype: str
        """
        return self._start_cursor

    @start_cursor.setter
    def start_cursor(self, start_cursor):
        """Sets the start_cursor of this PaginationInfo.

        Cursor used to retrieve the first set of documents.  # noqa: E501

        :param start_cursor: The start_cursor of this PaginationInfo.  # noqa: E501
        :type: str
        """

        self._start_cursor = start_cursor

    @property
    def next_cursor(self):
        """Gets the next_cursor of this PaginationInfo.  # noqa: E501

        Cursor to use to get the list of documents  # noqa: E501

        :return: The next_cursor of this PaginationInfo.  # noqa: E501
        :rtype: str
        """
        return self._next_cursor

    @next_cursor.setter
    def next_cursor(self, next_cursor):
        """Sets the next_cursor of this PaginationInfo.

        Cursor to use to get the list of documents  # noqa: E501

        :param next_cursor: The next_cursor of this PaginationInfo.  # noqa: E501
        :type: str
        """

        self._next_cursor = next_cursor

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PaginationInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaginationInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
