# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.query_lambda_sql import QueryLambdaSql  # noqa: F401,E501
from rockset.swagger_client.models.query_lambda_stats import QueryLambdaStats  # noqa: F401,E501


class QueryLambdaVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'workspace': 'str',
        'created_by': 'str',
        'created_at': 'str',
        'name': 'str',
        'version': 'str',
        'description': 'str',
        'sql': 'QueryLambdaSql',
        'collections': 'list[str]',
        'state': 'str',
        'stats': 'QueryLambdaStats'
    }

    attribute_map = {
        'workspace': 'workspace',
        'created_by': 'created_by',
        'created_at': 'created_at',
        'name': 'name',
        'version': 'version',
        'description': 'description',
        'sql': 'sql',
        'collections': 'collections',
        'state': 'state',
        'stats': 'stats'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """QueryLambdaVersion - a model defined in Swagger"""  # noqa: E501

        self._workspace = None
        self._created_by = None
        self._created_at = None
        self._name = None
        self._version = None
        self._description = None
        self._sql = None
        self._collections = None
        self._state = None
        self._stats = None
        self.discriminator = None

        self.workspace = kwargs.pop('workspace', None)
        self.created_by = kwargs.pop('created_by', None)
        self.created_at = kwargs.pop('created_at', None)
        self.name = kwargs.pop('name', None)
        self.version = kwargs.pop('version', None)
        self.description = kwargs.pop('description', None)
        self.sql = kwargs.pop('sql', None)
        self.collections = kwargs.pop('collections', None)
        self.state = kwargs.pop('state', None)
        self.stats = kwargs.pop('stats', None)

    @property
    def workspace(self):
        """Gets the workspace of this QueryLambdaVersion.  # noqa: E501

        workspace of this Query Lambda  # noqa: E501

        :return: The workspace of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this QueryLambdaVersion.

        workspace of this Query Lambda  # noqa: E501

        :param workspace: The workspace of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._workspace = workspace

    @property
    def created_by(self):
        """Gets the created_by of this QueryLambdaVersion.  # noqa: E501

        user that created this Query Lambda  # noqa: E501

        :return: The created_by of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this QueryLambdaVersion.

        user that created this Query Lambda  # noqa: E501

        :param created_by: The created_by of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def created_at(self):
        """Gets the created_at of this QueryLambdaVersion.  # noqa: E501

        ISO-8601 date of when Query Lambda was created  # noqa: E501

        :return: The created_at of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this QueryLambdaVersion.

        ISO-8601 date of when Query Lambda was created  # noqa: E501

        :param created_at: The created_at of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def name(self):
        """Gets the name of this QueryLambdaVersion.  # noqa: E501

        Query Lambda name  # noqa: E501

        :return: The name of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QueryLambdaVersion.

        Query Lambda name  # noqa: E501

        :param name: The name of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def version(self):
        """Gets the version of this QueryLambdaVersion.  # noqa: E501

        Query Lambda version  # noqa: E501

        :return: The version of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this QueryLambdaVersion.

        Query Lambda version  # noqa: E501

        :param version: The version of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def description(self):
        """Gets the description of this QueryLambdaVersion.  # noqa: E501

        optional description  # noqa: E501

        :return: The description of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this QueryLambdaVersion.

        optional description  # noqa: E501

        :param description: The description of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def sql(self):
        """Gets the sql of this QueryLambdaVersion.  # noqa: E501

        Query Lambda SQL query  # noqa: E501

        :return: The sql of this QueryLambdaVersion.  # noqa: E501
        :rtype: QueryLambdaSql
        """
        return self._sql

    @sql.setter
    def sql(self, sql):
        """Sets the sql of this QueryLambdaVersion.

        Query Lambda SQL query  # noqa: E501

        :param sql: The sql of this QueryLambdaVersion.  # noqa: E501
        :type: QueryLambdaSql
        """

        self._sql = sql

    @property
    def collections(self):
        """Gets the collections of this QueryLambdaVersion.  # noqa: E501

        collections queried by underlying SQL query  # noqa: E501

        :return: The collections of this QueryLambdaVersion.  # noqa: E501
        :rtype: list[str]
        """
        return self._collections

    @collections.setter
    def collections(self, collections):
        """Sets the collections of this QueryLambdaVersion.

        collections queried by underlying SQL query  # noqa: E501

        :param collections: The collections of this QueryLambdaVersion.  # noqa: E501
        :type: list[str]
        """

        self._collections = collections

    @property
    def state(self):
        """Gets the state of this QueryLambdaVersion.  # noqa: E501

        status of this Query Lambda  # noqa: E501

        :return: The state of this QueryLambdaVersion.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this QueryLambdaVersion.

        status of this Query Lambda  # noqa: E501

        :param state: The state of this QueryLambdaVersion.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def stats(self):
        """Gets the stats of this QueryLambdaVersion.  # noqa: E501

        stats related to this Query Lambda  # noqa: E501

        :return: The stats of this QueryLambdaVersion.  # noqa: E501
        :rtype: QueryLambdaStats
        """
        return self._stats

    @stats.setter
    def stats(self, stats):
        """Sets the stats of this QueryLambdaVersion.

        stats related to this Query Lambda  # noqa: E501

        :param stats: The stats of this QueryLambdaVersion.  # noqa: E501
        :type: QueryLambdaStats
        """

        self._stats = stats

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryLambdaVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryLambdaVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
