# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.query_parameter import QueryParameter  # noqa: F401,E501


class QueryRequestSql(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        'generate_warnings': 'bool',
        'profiling_enabled': 'bool',
        'parameters': 'list[QueryParameter]',
        'default_row_limit': 'int',
        'paginate': 'bool',
        'initial_paginate_response_doc_count': 'int'
    }

    attribute_map = {
        'query': 'query',
        'generate_warnings': 'generate_warnings',
        'profiling_enabled': 'profiling_enabled',
        'parameters': 'parameters',
        'default_row_limit': 'default_row_limit',
        'paginate': 'paginate',
        'initial_paginate_response_doc_count': 'initial_paginate_response_doc_count'
    }

    def __init__(self, query, **kwargs):  # noqa: E501
        """QueryRequestSql - a model defined in Swagger"""  # noqa: E501

        self._query = None
        self._generate_warnings = None
        self._profiling_enabled = None
        self._parameters = None
        self._default_row_limit = None
        self._paginate = None
        self._initial_paginate_response_doc_count = None
        self.discriminator = None

        self.query = query
        self.generate_warnings = kwargs.pop('generate_warnings', None)
        self.profiling_enabled = kwargs.pop('profiling_enabled', None)
        self.parameters = kwargs.pop('parameters', None)
        self.default_row_limit = kwargs.pop('default_row_limit', None)
        self.paginate = kwargs.pop('paginate', None)
        self.initial_paginate_response_doc_count = kwargs.pop('initial_paginate_response_doc_count', None)

    @property
    def query(self):
        """Gets the query of this QueryRequestSql.  # noqa: E501

        SQL query string.  # noqa: E501

        :return: The query of this QueryRequestSql.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this QueryRequestSql.

        SQL query string.  # noqa: E501

        :param query: The query of this QueryRequestSql.  # noqa: E501
        :type: str
        """

        self._query = query

    @property
    def generate_warnings(self):
        """Gets the generate_warnings of this QueryRequestSql.  # noqa: E501

        Flag to enable warnings. Warnings can help debug query issues but negatively affect performance.  # noqa: E501

        :return: The generate_warnings of this QueryRequestSql.  # noqa: E501
        :rtype: bool
        """
        return self._generate_warnings

    @generate_warnings.setter
    def generate_warnings(self, generate_warnings):
        """Sets the generate_warnings of this QueryRequestSql.

        Flag to enable warnings. Warnings can help debug query issues but negatively affect performance.  # noqa: E501

        :param generate_warnings: The generate_warnings of this QueryRequestSql.  # noqa: E501
        :type: bool
        """

        self._generate_warnings = generate_warnings

    @property
    def profiling_enabled(self):
        """Gets the profiling_enabled of this QueryRequestSql.  # noqa: E501

        Flag to generate a performance profile for this query.  # noqa: E501

        :return: The profiling_enabled of this QueryRequestSql.  # noqa: E501
        :rtype: bool
        """
        return self._profiling_enabled

    @profiling_enabled.setter
    def profiling_enabled(self, profiling_enabled):
        """Sets the profiling_enabled of this QueryRequestSql.

        Flag to generate a performance profile for this query.  # noqa: E501

        :param profiling_enabled: The profiling_enabled of this QueryRequestSql.  # noqa: E501
        :type: bool
        """

        self._profiling_enabled = profiling_enabled

    @property
    def parameters(self):
        """Gets the parameters of this QueryRequestSql.  # noqa: E501

        List of named parameters.  # noqa: E501

        :return: The parameters of this QueryRequestSql.  # noqa: E501
        :rtype: list[QueryParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this QueryRequestSql.

        List of named parameters.  # noqa: E501

        :param parameters: The parameters of this QueryRequestSql.  # noqa: E501
        :type: list[QueryParameter]
        """

        self._parameters = parameters

    @property
    def default_row_limit(self):
        """Gets the default_row_limit of this QueryRequestSql.  # noqa: E501

        Row limit to use. Limits specified in the query text will override this default.  # noqa: E501

        :return: The default_row_limit of this QueryRequestSql.  # noqa: E501
        :rtype: int
        """
        return self._default_row_limit

    @default_row_limit.setter
    def default_row_limit(self, default_row_limit):
        """Sets the default_row_limit of this QueryRequestSql.

        Row limit to use. Limits specified in the query text will override this default.  # noqa: E501

        :param default_row_limit: The default_row_limit of this QueryRequestSql.  # noqa: E501
        :type: int
        """

        self._default_row_limit = default_row_limit

    @property
    def paginate(self):
        """Gets the paginate of this QueryRequestSql.  # noqa: E501

        Flag to paginate and store the results of this query for later / sequential retrieval.  # noqa: E501

        :return: The paginate of this QueryRequestSql.  # noqa: E501
        :rtype: bool
        """
        return self._paginate

    @paginate.setter
    def paginate(self, paginate):
        """Sets the paginate of this QueryRequestSql.

        Flag to paginate and store the results of this query for later / sequential retrieval.  # noqa: E501

        :param paginate: The paginate of this QueryRequestSql.  # noqa: E501
        :type: bool
        """

        self._paginate = paginate

    @property
    def initial_paginate_response_doc_count(self):
        """Gets the initial_paginate_response_doc_count of this QueryRequestSql.  # noqa: E501

        Number of documents to return in addition to paginating for this query call. Only relevant if `paginate` flag is also set.  # noqa: E501

        :return: The initial_paginate_response_doc_count of this QueryRequestSql.  # noqa: E501
        :rtype: int
        """
        return self._initial_paginate_response_doc_count

    @initial_paginate_response_doc_count.setter
    def initial_paginate_response_doc_count(self, initial_paginate_response_doc_count):
        """Sets the initial_paginate_response_doc_count of this QueryRequestSql.

        Number of documents to return in addition to paginating for this query call. Only relevant if `paginate` flag is also set.  # noqa: E501

        :param initial_paginate_response_doc_count: The initial_paginate_response_doc_count of this QueryRequestSql.  # noqa: E501
        :type: int
        """

        self._initial_paginate_response_doc_count = initial_paginate_response_doc_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryRequestSql, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryRequestSql):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
