# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SourceGcs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bucket': 'str',
        'prefix': 'str',
        'object_count_downloaded': 'int',
        'object_count_total': 'int',
        'object_bytes_total': 'int'
    }

    attribute_map = {
        'bucket': 'bucket',
        'prefix': 'prefix',
        'object_count_downloaded': 'object_count_downloaded',
        'object_count_total': 'object_count_total',
        'object_bytes_total': 'object_bytes_total'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SourceGcs - a model defined in Swagger"""  # noqa: E501

        self._bucket = None
        self._prefix = None
        self._object_count_downloaded = None
        self._object_count_total = None
        self._object_bytes_total = None
        self.discriminator = None

        self.bucket = kwargs.pop('bucket', None)
        self.prefix = kwargs.pop('prefix', None)
        self.object_count_downloaded = kwargs.pop('object_count_downloaded', None)
        self.object_count_total = kwargs.pop('object_count_total', None)
        self.object_bytes_total = kwargs.pop('object_bytes_total', None)

    @property
    def bucket(self):
        """Gets the bucket of this SourceGcs.  # noqa: E501

        name of GCS bucket you want to ingest from  # noqa: E501

        :return: The bucket of this SourceGcs.  # noqa: E501
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """Sets the bucket of this SourceGcs.

        name of GCS bucket you want to ingest from  # noqa: E501

        :param bucket: The bucket of this SourceGcs.  # noqa: E501
        :type: str
        """

        self._bucket = bucket

    @property
    def prefix(self):
        """Gets the prefix of this SourceGcs.  # noqa: E501

        Prefix that selects keys to ingest.  # noqa: E501

        :return: The prefix of this SourceGcs.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this SourceGcs.

        Prefix that selects keys to ingest.  # noqa: E501

        :param prefix: The prefix of this SourceGcs.  # noqa: E501
        :type: str
        """

        self._prefix = prefix

    @property
    def object_count_downloaded(self):
        """Gets the object_count_downloaded of this SourceGcs.  # noqa: E501


        :return: The object_count_downloaded of this SourceGcs.  # noqa: E501
        :rtype: int
        """
        return self._object_count_downloaded

    @object_count_downloaded.setter
    def object_count_downloaded(self, object_count_downloaded):
        """Sets the object_count_downloaded of this SourceGcs.


        :param object_count_downloaded: The object_count_downloaded of this SourceGcs.  # noqa: E501
        :type: int
        """

        self._object_count_downloaded = object_count_downloaded

    @property
    def object_count_total(self):
        """Gets the object_count_total of this SourceGcs.  # noqa: E501


        :return: The object_count_total of this SourceGcs.  # noqa: E501
        :rtype: int
        """
        return self._object_count_total

    @object_count_total.setter
    def object_count_total(self, object_count_total):
        """Sets the object_count_total of this SourceGcs.


        :param object_count_total: The object_count_total of this SourceGcs.  # noqa: E501
        :type: int
        """

        self._object_count_total = object_count_total

    @property
    def object_bytes_total(self):
        """Gets the object_bytes_total of this SourceGcs.  # noqa: E501


        :return: The object_bytes_total of this SourceGcs.  # noqa: E501
        :rtype: int
        """
        return self._object_bytes_total

    @object_bytes_total.setter
    def object_bytes_total(self, object_bytes_total):
        """Sets the object_bytes_total of this SourceGcs.


        :param object_bytes_total: The object_bytes_total of this SourceGcs.  # noqa: E501
        :type: int
        """

        self._object_bytes_total = object_bytes_total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceGcs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceGcs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
