# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.status_kafka import StatusKafka  # noqa: F401,E501


class SourceKafka(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kafka_topic_name': 'str',
        'status': 'StatusKafka',
        'use_v3': 'bool',
        'offset_reset_policy': 'str'
    }

    attribute_map = {
        'kafka_topic_name': 'kafka_topic_name',
        'status': 'status',
        'use_v3': 'use_v3',
        'offset_reset_policy': 'offset_reset_policy'
    }

    def __init__(self, kafka_topic_name, **kwargs):  # noqa: E501
        """SourceKafka - a model defined in Swagger"""  # noqa: E501

        self._kafka_topic_name = None
        self._status = None
        self._use_v3 = None
        self._offset_reset_policy = None
        self.discriminator = None

        self.kafka_topic_name = kafka_topic_name
        self.status = kwargs.pop('status', None)
        self.use_v3 = kwargs.pop('use_v3', None)
        self.offset_reset_policy = kwargs.pop('offset_reset_policy', None)

    @property
    def kafka_topic_name(self):
        """Gets the kafka_topic_name of this SourceKafka.  # noqa: E501

        The Kafka topic to be tailed  # noqa: E501

        :return: The kafka_topic_name of this SourceKafka.  # noqa: E501
        :rtype: str
        """
        return self._kafka_topic_name

    @kafka_topic_name.setter
    def kafka_topic_name(self, kafka_topic_name):
        """Sets the kafka_topic_name of this SourceKafka.

        The Kafka topic to be tailed  # noqa: E501

        :param kafka_topic_name: The kafka_topic_name of this SourceKafka.  # noqa: E501
        :type: str
        """

        self._kafka_topic_name = kafka_topic_name

    @property
    def status(self):
        """Gets the status of this SourceKafka.  # noqa: E501

        Kafka source status  # noqa: E501

        :return: The status of this SourceKafka.  # noqa: E501
        :rtype: StatusKafka
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SourceKafka.

        Kafka source status  # noqa: E501

        :param status: The status of this SourceKafka.  # noqa: E501
        :type: StatusKafka
        """

        self._status = status

    @property
    def use_v3(self):
        """Gets the use_v3 of this SourceKafka.  # noqa: E501


        :return: The use_v3 of this SourceKafka.  # noqa: E501
        :rtype: bool
        """
        return self._use_v3

    @use_v3.setter
    def use_v3(self, use_v3):
        """Sets the use_v3 of this SourceKafka.


        :param use_v3: The use_v3 of this SourceKafka.  # noqa: E501
        :type: bool
        """

        self._use_v3 = use_v3

    @property
    def offset_reset_policy(self):
        """Gets the offset_reset_policy of this SourceKafka.  # noqa: E501


        :return: The offset_reset_policy of this SourceKafka.  # noqa: E501
        :rtype: str
        """
        return self._offset_reset_policy

    @offset_reset_policy.setter
    def offset_reset_policy(self, offset_reset_policy):
        """Sets the offset_reset_policy of this SourceKafka.


        :param offset_reset_policy: The offset_reset_policy of this SourceKafka.  # noqa: E501
        :type: str
        """

        self._offset_reset_policy = offset_reset_policy

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceKafka, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceKafka):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
