# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.status_mongo_db import StatusMongoDb  # noqa: F401,E501


class SourceMongoDb(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'database_name': 'str',
        'collection_name': 'str',
        'status': 'StatusMongoDb'
    }

    attribute_map = {
        'database_name': 'database_name',
        'collection_name': 'collection_name',
        'status': 'status'
    }

    def __init__(self, database_name, collection_name, **kwargs):  # noqa: E501
        """SourceMongoDb - a model defined in Swagger"""  # noqa: E501

        self._database_name = None
        self._collection_name = None
        self._status = None
        self.discriminator = None

        self.database_name = database_name
        self.collection_name = collection_name
        self.status = kwargs.pop('status', None)

    @property
    def database_name(self):
        """Gets the database_name of this SourceMongoDb.  # noqa: E501

        MongoDB database name containing this collection  # noqa: E501

        :return: The database_name of this SourceMongoDb.  # noqa: E501
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """Sets the database_name of this SourceMongoDb.

        MongoDB database name containing this collection  # noqa: E501

        :param database_name: The database_name of this SourceMongoDb.  # noqa: E501
        :type: str
        """

        self._database_name = database_name

    @property
    def collection_name(self):
        """Gets the collection_name of this SourceMongoDb.  # noqa: E501

        MongoDB collection name  # noqa: E501

        :return: The collection_name of this SourceMongoDb.  # noqa: E501
        :rtype: str
        """
        return self._collection_name

    @collection_name.setter
    def collection_name(self, collection_name):
        """Sets the collection_name of this SourceMongoDb.

        MongoDB collection name  # noqa: E501

        :param collection_name: The collection_name of this SourceMongoDb.  # noqa: E501
        :type: str
        """

        self._collection_name = collection_name

    @property
    def status(self):
        """Gets the status of this SourceMongoDb.  # noqa: E501

        MongoDB source status  # noqa: E501

        :return: The status of this SourceMongoDb.  # noqa: E501
        :rtype: StatusMongoDb
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SourceMongoDb.

        MongoDB source status  # noqa: E501

        :param status: The status of this SourceMongoDb.  # noqa: E501
        :type: StatusMongoDb
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceMongoDb, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceMongoDb):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
