# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.field_mask import FieldMask  # noqa: F401,E501


class SourceS3(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_key': 'str',
        'secret_access': 'str',
        'prefix': 'str',
        'pattern': 'str',
        'region': 'str',
        'bucket': 'str',
        'prefixes': 'list[str]',
        'format': 'str',
        'mappings': 'list[FieldMask]',
        'object_count_downloaded': 'int',
        'object_count_total': 'int',
        'object_bytes_total': 'int'
    }

    attribute_map = {
        'access_key': 'access_key',
        'secret_access': 'secret_access',
        'prefix': 'prefix',
        'pattern': 'pattern',
        'region': 'region',
        'bucket': 'bucket',
        'prefixes': 'prefixes',
        'format': 'format',
        'mappings': 'mappings',
        'object_count_downloaded': 'object_count_downloaded',
        'object_count_total': 'object_count_total',
        'object_bytes_total': 'object_bytes_total'
    }

    def __init__(self, bucket, prefixes, **kwargs):  # noqa: E501
        """SourceS3 - a model defined in Swagger"""  # noqa: E501

        self._access_key = None
        self._secret_access = None
        self._prefix = None
        self._pattern = None
        self._region = None
        self._bucket = None
        self._prefixes = None
        self._format = None
        self._mappings = None
        self._object_count_downloaded = None
        self._object_count_total = None
        self._object_bytes_total = None
        self.discriminator = None

        self.access_key = kwargs.pop('access_key', None)
        self.secret_access = kwargs.pop('secret_access', None)
        self.prefix = kwargs.pop('prefix', None)
        self.pattern = kwargs.pop('pattern', None)
        self.region = kwargs.pop('region', None)
        self.bucket = bucket
        self.prefixes = prefixes
        self.format = kwargs.pop('format', None)
        self.mappings = kwargs.pop('mappings', None)
        self.object_count_downloaded = kwargs.pop('object_count_downloaded', None)
        self.object_count_total = kwargs.pop('object_count_total', None)
        self.object_bytes_total = kwargs.pop('object_bytes_total', None)

    @property
    def access_key(self):
        """Gets the access_key of this SourceS3.  # noqa: E501

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :return: The access_key of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._access_key

    @access_key.setter
    def access_key(self, access_key):
        """Sets the access_key of this SourceS3.

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :param access_key: The access_key of this SourceS3.  # noqa: E501
        :type: str
        """

        self._access_key = access_key

    @property
    def secret_access(self):
        """Gets the secret_access of this SourceS3.  # noqa: E501

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :return: The secret_access of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._secret_access

    @secret_access.setter
    def secret_access(self, secret_access):
        """Sets the secret_access of this SourceS3.

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :param secret_access: The secret_access of this SourceS3.  # noqa: E501
        :type: str
        """

        self._secret_access = secret_access

    @property
    def prefix(self):
        """Gets the prefix of this SourceS3.  # noqa: E501

        Prefix that selects keys to ingest.  # noqa: E501

        :return: The prefix of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this SourceS3.

        Prefix that selects keys to ingest.  # noqa: E501

        :param prefix: The prefix of this SourceS3.  # noqa: E501
        :type: str
        """

        self._prefix = prefix

    @property
    def pattern(self):
        """Gets the pattern of this SourceS3.  # noqa: E501

        Pattern that selects keys to ingest.  # noqa: E501

        :return: The pattern of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this SourceS3.

        Pattern that selects keys to ingest.  # noqa: E501

        :param pattern: The pattern of this SourceS3.  # noqa: E501
        :type: str
        """

        self._pattern = pattern

    @property
    def region(self):
        """Gets the region of this SourceS3.  # noqa: E501

        AWS region containing source bucket  # noqa: E501

        :return: The region of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this SourceS3.

        AWS region containing source bucket  # noqa: E501

        :param region: The region of this SourceS3.  # noqa: E501
        :type: str
        """

        self._region = region

    @property
    def bucket(self):
        """Gets the bucket of this SourceS3.  # noqa: E501

        address of S3 bucket containing data  # noqa: E501

        :return: The bucket of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """Sets the bucket of this SourceS3.

        address of S3 bucket containing data  # noqa: E501

        :param bucket: The bucket of this SourceS3.  # noqa: E501
        :type: str
        """

        self._bucket = bucket

    @property
    def prefixes(self):
        """Gets the prefixes of this SourceS3.  # noqa: E501

        list of prefixes to paths from which data should be ingested  # noqa: E501

        :return: The prefixes of this SourceS3.  # noqa: E501
        :rtype: list[str]
        """
        return self._prefixes

    @prefixes.setter
    def prefixes(self, prefixes):
        """Sets the prefixes of this SourceS3.

        list of prefixes to paths from which data should be ingested  # noqa: E501

        :param prefixes: The prefixes of this SourceS3.  # noqa: E501
        :type: list[str]
        """

        self._prefixes = prefixes

    @property
    def format(self):
        """Gets the format of this SourceS3.  # noqa: E501

        do not use  # noqa: E501

        :return: The format of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this SourceS3.

        do not use  # noqa: E501

        :param format: The format of this SourceS3.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def mappings(self):
        """Gets the mappings of this SourceS3.  # noqa: E501

        custom transformation on data field  # noqa: E501

        :return: The mappings of this SourceS3.  # noqa: E501
        :rtype: list[FieldMask]
        """
        return self._mappings

    @mappings.setter
    def mappings(self, mappings):
        """Sets the mappings of this SourceS3.

        custom transformation on data field  # noqa: E501

        :param mappings: The mappings of this SourceS3.  # noqa: E501
        :type: list[FieldMask]
        """

        self._mappings = mappings

    @property
    def object_count_downloaded(self):
        """Gets the object_count_downloaded of this SourceS3.  # noqa: E501


        :return: The object_count_downloaded of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_count_downloaded

    @object_count_downloaded.setter
    def object_count_downloaded(self, object_count_downloaded):
        """Sets the object_count_downloaded of this SourceS3.


        :param object_count_downloaded: The object_count_downloaded of this SourceS3.  # noqa: E501
        :type: int
        """

        self._object_count_downloaded = object_count_downloaded

    @property
    def object_count_total(self):
        """Gets the object_count_total of this SourceS3.  # noqa: E501


        :return: The object_count_total of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_count_total

    @object_count_total.setter
    def object_count_total(self, object_count_total):
        """Sets the object_count_total of this SourceS3.


        :param object_count_total: The object_count_total of this SourceS3.  # noqa: E501
        :type: int
        """

        self._object_count_total = object_count_total

    @property
    def object_bytes_total(self):
        """Gets the object_bytes_total of this SourceS3.  # noqa: E501


        :return: The object_bytes_total of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_bytes_total

    @object_bytes_total.setter
    def object_bytes_total(self, object_bytes_total):
        """Sets the object_bytes_total of this SourceS3.


        :param object_bytes_total: The object_bytes_total of this SourceS3.  # noqa: E501
        :type: int
        """

        self._object_bytes_total = object_bytes_total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceS3, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceS3):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
