# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.status_kafka_partition import StatusKafkaPartition  # noqa: F401,E501


class StatusKafka(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'state': 'str',
        'last_consumed_time': 'str',
        'num_documents_processed': 'int',
        'kafka_partitions': 'list[StatusKafkaPartition]'
    }

    attribute_map = {
        'state': 'state',
        'last_consumed_time': 'last_consumed_time',
        'num_documents_processed': 'num_documents_processed',
        'kafka_partitions': 'kafka_partitions'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """StatusKafka - a model defined in Swagger"""  # noqa: E501

        self._state = None
        self._last_consumed_time = None
        self._num_documents_processed = None
        self._kafka_partitions = None
        self.discriminator = None

        self.state = kwargs.pop('state', None)
        self.last_consumed_time = kwargs.pop('last_consumed_time', None)
        self.num_documents_processed = kwargs.pop('num_documents_processed', None)
        self.kafka_partitions = kwargs.pop('kafka_partitions', None)

    @property
    def state(self):
        """Gets the state of this StatusKafka.  # noqa: E501

        State of the Kafka source  # noqa: E501

        :return: The state of this StatusKafka.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this StatusKafka.

        State of the Kafka source  # noqa: E501

        :param state: The state of this StatusKafka.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def last_consumed_time(self):
        """Gets the last_consumed_time of this StatusKafka.  # noqa: E501

        Time at which the last document was consumed from Kafka  # noqa: E501

        :return: The last_consumed_time of this StatusKafka.  # noqa: E501
        :rtype: str
        """
        return self._last_consumed_time

    @last_consumed_time.setter
    def last_consumed_time(self, last_consumed_time):
        """Sets the last_consumed_time of this StatusKafka.

        Time at which the last document was consumed from Kafka  # noqa: E501

        :param last_consumed_time: The last_consumed_time of this StatusKafka.  # noqa: E501
        :type: str
        """

        self._last_consumed_time = last_consumed_time

    @property
    def num_documents_processed(self):
        """Gets the num_documents_processed of this StatusKafka.  # noqa: E501

        Number of documents consumed by this Kafka topic  # noqa: E501

        :return: The num_documents_processed of this StatusKafka.  # noqa: E501
        :rtype: int
        """
        return self._num_documents_processed

    @num_documents_processed.setter
    def num_documents_processed(self, num_documents_processed):
        """Sets the num_documents_processed of this StatusKafka.

        Number of documents consumed by this Kafka topic  # noqa: E501

        :param num_documents_processed: The num_documents_processed of this StatusKafka.  # noqa: E501
        :type: int
        """

        self._num_documents_processed = num_documents_processed

    @property
    def kafka_partitions(self):
        """Gets the kafka_partitions of this StatusKafka.  # noqa: E501

        Status info per partition  # noqa: E501

        :return: The kafka_partitions of this StatusKafka.  # noqa: E501
        :rtype: list[StatusKafkaPartition]
        """
        return self._kafka_partitions

    @kafka_partitions.setter
    def kafka_partitions(self, kafka_partitions):
        """Sets the kafka_partitions of this StatusKafka.

        Status info per partition  # noqa: E501

        :param kafka_partitions: The kafka_partitions of this StatusKafka.  # noqa: E501
        :type: list[StatusKafkaPartition]
        """

        self._kafka_partitions = kafka_partitions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StatusKafka, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusKafka):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
