# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.privilege import Privilege  # noqa: F401,E501


class UpdateRoleRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'privileges': 'list[Privilege]'
    }

    attribute_map = {
        'description': 'description',
        'privileges': 'privileges'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UpdateRoleRequest - a model defined in Swagger"""  # noqa: E501

        self._description = None
        self._privileges = None
        self.discriminator = None

        self.description = kwargs.pop('description', None)
        self.privileges = kwargs.pop('privileges', None)

    @property
    def description(self):
        """Gets the description of this UpdateRoleRequest.  # noqa: E501

        Description for the role.  # noqa: E501

        :return: The description of this UpdateRoleRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this UpdateRoleRequest.

        Description for the role.  # noqa: E501

        :param description: The description of this UpdateRoleRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def privileges(self):
        """Gets the privileges of this UpdateRoleRequest.  # noqa: E501

        List of privileges that will be associated with the role.  # noqa: E501

        :return: The privileges of this UpdateRoleRequest.  # noqa: E501
        :rtype: list[Privilege]
        """
        return self._privileges

    @privileges.setter
    def privileges(self, privileges):
        """Sets the privileges of this UpdateRoleRequest.

        List of privileges that will be associated with the role.  # noqa: E501

        :param privileges: The privileges of this UpdateRoleRequest.  # noqa: E501
        :type: list[Privilege]
        """

        self._privileges = privileges

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UpdateRoleRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateRoleRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
