# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UpdateVirtualInstanceRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'new_size': 'str',
        'new_type': 'str',
        'monitoring_enabled': 'bool'
    }

    attribute_map = {
        'new_size': 'new_size',
        'new_type': 'new_type',
        'monitoring_enabled': 'monitoring_enabled'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UpdateVirtualInstanceRequest - a model defined in Swagger"""  # noqa: E501

        self._new_size = None
        self._new_type = None
        self._monitoring_enabled = None
        self.discriminator = None

        self.new_size = kwargs.pop('new_size', None)
        self.new_type = kwargs.pop('new_type', None)
        self.monitoring_enabled = kwargs.pop('monitoring_enabled', None)

    @property
    def new_size(self):
        """Gets the new_size of this UpdateVirtualInstanceRequest.  # noqa: E501

        requested virtual instance size  # noqa: E501

        :return: The new_size of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: str
        """
        return self._new_size

    @new_size.setter
    def new_size(self, new_size):
        """Sets the new_size of this UpdateVirtualInstanceRequest.

        requested virtual instance size  # noqa: E501

        :param new_size: The new_size of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type: str
        """

        self._new_size = new_size

    @property
    def new_type(self):
        """Gets the new_type of this UpdateVirtualInstanceRequest.  # noqa: E501


        :return: The new_type of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: str
        """
        return self._new_type

    @new_type.setter
    def new_type(self, new_type):
        """Sets the new_type of this UpdateVirtualInstanceRequest.


        :param new_type: The new_type of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type: str
        """

        self._new_type = new_type

    @property
    def monitoring_enabled(self):
        """Gets the monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501


        :return: The monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: bool
        """
        return self._monitoring_enabled

    @monitoring_enabled.setter
    def monitoring_enabled(self, monitoring_enabled):
        """Sets the monitoring_enabled of this UpdateVirtualInstanceRequest.


        :param monitoring_enabled: The monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type: bool
        """

        self._monitoring_enabled = monitoring_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UpdateVirtualInstanceRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateVirtualInstanceRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
