/// <reference types="node" />
import { SpawnSyncOptions } from 'child_process';
/**
 * A parsed stack trace line
 */
export interface StackTrace {
    readonly file: string;
    readonly methodName?: string;
    readonly lineNumber: number;
    readonly column: number;
}
/**
 * Parses the stack trace of an error
 */
export declare function parseStackTrace(error?: Error): StackTrace[];
/**
 * Returns the major version of node installation
 */
export declare function nodeMajorVersion(): number;
/**
 * Find a file by walking up parent directories
 */
export declare function findUp(name: string, directory?: string): string | undefined;
/**
 * Spawn sync with error handling
 */
export declare function exec(cmd: string, args: string[], options?: SpawnSyncOptions): import("child_process").SpawnSyncReturns<Buffer>;
