# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .case_management_event_case_status import CaseManagementEventCaseStatus
from .case_management_event_case_status_reason import CaseManagementEventCaseStatusReason


class CaseManagementEvent(pydantic.BaseModel):
    """
    Model for case management events
    """

    case_status: CaseManagementEventCaseStatus = pydantic.Field(
        alias="caseStatus", description="Status of a case. E.g. Open, Closed etc."
    )
    timestamp: float = pydantic.Field(description="Timestamp of the event")
    case_status_reason: CaseManagementEventCaseStatusReason = pydantic.Field(
        alias="caseStatusReason",
        description="Case status reason. E.g. Closed & False Positive, Closed & Investigation Completed etc.",
    )
    transaction_id: typing.Optional[str] = pydantic.Field(
        alias="transactionId",
        description='Transaction ID the case pertains to <span style="white-space: nowrap">`non-empty`</span> ',
    )
    user_id: typing.Optional[str] = pydantic.Field(alias="userId", description="User ID the case pertains to")
    event_id: typing.Optional[str] = pydantic.Field(alias="eventId", description="Event ID the case pertains to")
    case_status_reason_description: typing.Optional[str] = pydantic.Field(
        alias="caseStatusReasonDescription", description="Case status reason description"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
