# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .country_code import CountryCode
from .tag import Tag


class CompanyRegistrationDetails(pydantic.BaseModel):
    """
    Model for business user company registration details
    """

    registration_identifier: str = pydantic.Field(
        alias="registrationIdentifier",
        description='Commercial registry registration number for the company in its registration country <span style="white-space: nowrap">`non-empty`</span> ',
    )
    registration_country: CountryCode = pydantic.Field(alias="registrationCountry")
    tax_identifier: typing.Optional[str] = pydantic.Field(
        alias="taxIdentifier", description="Tax ID number of the registered entity"
    )
    legal_entity_type: typing.Optional[str] = pydantic.Field(
        alias="legalEntityType", description="Type of legal entity. Ex: Limited Liability"
    )
    date_of_registration: typing.Optional[str] = pydantic.Field(alias="dateOfRegistration")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
