# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime


class Tag(pydantic.BaseModel):
    """
    Generic key-value pair model to append a custom variable being sent to Flagright API
    """

    key: str = pydantic.Field(
        description='Key value when you are creating a custom variable <span style="white-space: nowrap">`non-empty`</span> '
    )
    value: str = pydantic.Field(
        description='Value for a given key when you are creating a custom variable <span style="white-space: nowrap">`non-empty`</span> '
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
