# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .country_code import CountryCode
from .currency_code import CurrencyCode


class TransactionAmountDetails(pydantic.BaseModel):
    """
    Model for transaction amount details
    """

    transaction_amount: float = pydantic.Field(alias="transactionAmount", description="Amount of the transaction")
    transaction_currency: CurrencyCode = pydantic.Field(alias="transactionCurrency")
    country: typing.Optional[CountryCode]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
