# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .amount import Amount
from .tag import Tag
from .wallet_payment_method import WalletPaymentMethod


class WalletDetails(pydantic.BaseModel):
    """
    Standardized model for a Generic wallet transaction
    """

    method: WalletPaymentMethod
    wallet_type: str = pydantic.Field(
        alias="walletType",
        description="Wallet type if there are various types of wallets belonging to the same user. E.g. Checking, savings, vault, different currency wallets etc.",
    )
    wallet_id: typing.Optional[str] = pydantic.Field(
        alias="walletId", description='Unique ID of the wallet <span style="white-space: nowrap">`non-empty`</span> '
    )
    payment_channel: typing.Optional[str] = pydantic.Field(
        alias="paymentChannel", description="Payment Channel used through wallet"
    )
    name: typing.Optional[str] = pydantic.Field(description="Name of the account holder for a specific wallet")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )
    wallet_phone_number: typing.Optional[str] = pydantic.Field(
        alias="walletPhoneNumber", description="Phone number associated with the wallet, if any"
    )
    wallet_balance: typing.Optional[Amount] = pydantic.Field(alias="walletBalance")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
