"""
    CarbonAware.WebApi

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from carbon_sdk_client.openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from carbon_sdk_client.openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from carbon_sdk_client.openapi_client.model.carbon_intensity_batch_parameters_dto import CarbonIntensityBatchParametersDTO
from carbon_sdk_client.openapi_client.model.carbon_intensity_dto import CarbonIntensityDTO
from carbon_sdk_client.openapi_client.model.emissions_data import EmissionsData
from carbon_sdk_client.openapi_client.model.emissions_forecast_batch_parameters_dto import EmissionsForecastBatchParametersDTO
from carbon_sdk_client.openapi_client.model.emissions_forecast_dto import EmissionsForecastDTO
from carbon_sdk_client.openapi_client.model.validation_problem_details import ValidationProblemDetails


class CarbonAwareApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.batch_forecast_data_async_endpoint = _Endpoint(
            settings={
                'response_type': ([EmissionsForecastDTO],),
                'auth': [],
                'endpoint_path': '/emissions/forecasts/batch',
                'operation_id': 'batch_forecast_data_async',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'emissions_forecast_batch_parameters_dto',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'emissions_forecast_batch_parameters_dto':
                        ([EmissionsForecastBatchParametersDTO],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'emissions_forecast_batch_parameters_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.get_average_carbon_intensity_endpoint = _Endpoint(
            settings={
                'response_type': (CarbonIntensityDTO,),
                'auth': [],
                'endpoint_path': '/emissions/average-carbon-intensity',
                'operation_id': 'get_average_carbon_intensity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'location',
                    'start_time',
                    'end_time',
                ],
                'required': [
                    'location',
                    'start_time',
                    'end_time',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'location':
                        (str,),
                    'start_time':
                        (datetime,),
                    'end_time':
                        (datetime,),
                },
                'attribute_map': {
                    'location': 'location',
                    'start_time': 'startTime',
                    'end_time': 'endTime',
                },
                'location_map': {
                    'location': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_average_carbon_intensity_batch_endpoint = _Endpoint(
            settings={
                'response_type': ([CarbonIntensityDTO],),
                'auth': [],
                'endpoint_path': '/emissions/average-carbon-intensity/batch',
                'operation_id': 'get_average_carbon_intensity_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'carbon_intensity_batch_parameters_dto',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'carbon_intensity_batch_parameters_dto':
                        ([CarbonIntensityBatchParametersDTO],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'carbon_intensity_batch_parameters_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.get_best_emissions_data_for_locations_by_time_endpoint = _Endpoint(
            settings={
                'response_type': ([EmissionsData],),
                'auth': [],
                'endpoint_path': '/emissions/bylocations/best',
                'operation_id': 'get_best_emissions_data_for_locations_by_time',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'location',
                    'time',
                    'to_time',
                ],
                'required': [
                    'location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'location':
                        ([str],),
                    'time':
                        (datetime,),
                    'to_time':
                        (datetime,),
                },
                'attribute_map': {
                    'location': 'location',
                    'time': 'time',
                    'to_time': 'toTime',
                },
                'location_map': {
                    'location': 'query',
                    'time': 'query',
                    'to_time': 'query',
                },
                'collection_format_map': {
                    'location': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_current_forecast_data_endpoint = _Endpoint(
            settings={
                'response_type': ([EmissionsForecastDTO],),
                'auth': [],
                'endpoint_path': '/emissions/forecasts/current',
                'operation_id': 'get_current_forecast_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'location',
                    'data_start_at',
                    'data_end_at',
                    'window_size',
                ],
                'required': [
                    'location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'location':
                        ([str],),
                    'data_start_at':
                        (datetime,),
                    'data_end_at':
                        (datetime,),
                    'window_size':
                        (int,),
                },
                'attribute_map': {
                    'location': 'location',
                    'data_start_at': 'dataStartAt',
                    'data_end_at': 'dataEndAt',
                    'window_size': 'windowSize',
                },
                'location_map': {
                    'location': 'query',
                    'data_start_at': 'query',
                    'data_end_at': 'query',
                    'window_size': 'query',
                },
                'collection_format_map': {
                    'location': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_emissions_data_for_location_by_time_endpoint = _Endpoint(
            settings={
                'response_type': ([EmissionsData],),
                'auth': [],
                'endpoint_path': '/emissions/bylocation',
                'operation_id': 'get_emissions_data_for_location_by_time',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'location',
                    'time',
                    'to_time',
                ],
                'required': [
                    'location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'location':
                        (str,),
                    'time':
                        (datetime,),
                    'to_time':
                        (datetime,),
                },
                'attribute_map': {
                    'location': 'location',
                    'time': 'time',
                    'to_time': 'toTime',
                },
                'location_map': {
                    'location': 'query',
                    'time': 'query',
                    'to_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_emissions_data_for_locations_by_time_endpoint = _Endpoint(
            settings={
                'response_type': ([EmissionsData],),
                'auth': [],
                'endpoint_path': '/emissions/bylocations',
                'operation_id': 'get_emissions_data_for_locations_by_time',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'location',
                    'time',
                    'to_time',
                ],
                'required': [
                    'location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'location':
                        ([str],),
                    'time':
                        (datetime,),
                    'to_time':
                        (datetime,),
                },
                'attribute_map': {
                    'location': 'location',
                    'time': 'time',
                    'to_time': 'toTime',
                },
                'location_map': {
                    'location': 'query',
                    'time': 'query',
                    'to_time': 'query',
                },
                'collection_format_map': {
                    'location': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def batch_forecast_data_async(
        self,
        **kwargs
    ):
        """Given an array of historical forecasts, retrieves the data that contains  forecasts metadata, the optimal forecast and a range of forecasts filtered by the attributes [start...end] if provided.  # noqa: E501

        This endpoint takes a batch of requests for historical forecast data, fetches them, and calculates the optimal   marginal carbon intensity windows for each using the same parameters available to the '/emissions/forecasts/current'  endpoint.                This endpoint is useful for back-testing what one might have done in the past, if they had access to the   current forecast at the time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_forecast_data_async(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            emissions_forecast_batch_parameters_dto ([EmissionsForecastBatchParametersDTO]): Array of requested forecasts.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EmissionsForecastDTO]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.batch_forecast_data_async_endpoint.call_with_http_info(**kwargs)

    def get_average_carbon_intensity(
        self,
        location,
        start_time,
        end_time,
        **kwargs
    ):
        """Retrieves the measured carbon intensity data between the time boundaries and calculates the average carbon intensity during that period.  # noqa: E501

        This endpoint is useful for reporting the measured carbon intensity for a specific time period in a specific location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_average_carbon_intensity(location, start_time, end_time, async_req=True)
        >>> result = thread.get()

        Args:
            location (str): The location name where workflow is run
            start_time (datetime): The time at which the workflow we are measuring carbon intensity for started
            end_time (datetime): The time at which the workflow we are measuring carbon intensity for ended

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CarbonIntensityDTO
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['location'] = \
            location
        kwargs['start_time'] = \
            start_time
        kwargs['end_time'] = \
            end_time
        return self.get_average_carbon_intensity_endpoint.call_with_http_info(**kwargs)

    def get_average_carbon_intensity_batch(
        self,
        **kwargs
    ):
        """Given an array of request objects, each with their own location and time boundaries, calculate the average carbon intensity for that location and time period   and return an array of carbon intensity objects.  # noqa: E501

        The application only supports batching across a single location with different time boundaries. If multiple locations are provided, an error is returned.  For each item in the request array, the application returns a corresponding object containing the location, time boundaries, and average marginal carbon intensity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_average_carbon_intensity_batch(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            carbon_intensity_batch_parameters_dto ([CarbonIntensityBatchParametersDTO]): Array of inputs where each contains a \"location\", \"startDate\", and \"endDate\" for which to calculate average marginal carbon intensity.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [CarbonIntensityDTO]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_average_carbon_intensity_batch_endpoint.call_with_http_info(**kwargs)

    def get_best_emissions_data_for_locations_by_time(
        self,
        location,
        **kwargs
    ):
        """Calculate the best emission data by list of locations for a specified time period.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_best_emissions_data_for_locations_by_time(location, async_req=True)
        >>> result = thread.get()

        Args:
            location ([str]): String array of named locations

        Keyword Args:
            time (datetime): [Optional] Start time for the data query.. [optional]
            to_time (datetime): [Optional] End time for the data query.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EmissionsData]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['location'] = \
            location
        return self.get_best_emissions_data_for_locations_by_time_endpoint.call_with_http_info(**kwargs)

    def get_current_forecast_data(
        self,
        location,
        **kwargs
    ):
        """Retrieves the most recent forecasted data and calculates the optimal marginal carbon intensity window.  # noqa: E501

        This endpoint fetches only the most recently generated forecast for all provided locations.  It uses the \"dataStartAt\" and   \"dataEndAt\" parameters to scope the forecasted data points (if available for those times). If no start or end time   boundaries are provided, the entire forecast dataset is used. The scoped data points are used to calculate average marginal   carbon intensities of the specified \"windowSize\" and the optimal marginal carbon intensity window is identified.                The forecast data represents what the data source predicts future marginal carbon intesity values to be,   not actual measured emissions data (as future values cannot be known).                This endpoint is useful for determining if there is a more carbon-optimal time to use electicity predicted in the future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_forecast_data(location, async_req=True)
        >>> result = thread.get()

        Args:
            location ([str]): String array of named locations

        Keyword Args:
            data_start_at (datetime): Start time boundary of forecasted data points.Ignores current forecast data points before this time.  Defaults to the earliest time in the forecast data.. [optional]
            data_end_at (datetime): End time boundary of forecasted data points. Ignores current forecast data points after this time.  Defaults to the latest time in the forecast data.. [optional]
            window_size (int): The estimated duration (in minutes) of the workload.  Defaults to the duration of a single forecast data point.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EmissionsForecastDTO]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['location'] = \
            location
        return self.get_current_forecast_data_endpoint.call_with_http_info(**kwargs)

    def get_emissions_data_for_location_by_time(
        self,
        location,
        **kwargs
    ):
        """Calculate the best emission data by location for a specified time period.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_emissions_data_for_location_by_time(location, async_req=True)
        >>> result = thread.get()

        Args:
            location (str): String named location.

        Keyword Args:
            time (datetime): [Optional] Start time for the data query.. [optional]
            to_time (datetime): [Optional] End time for the data query.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EmissionsData]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['location'] = \
            location
        return self.get_emissions_data_for_location_by_time_endpoint.call_with_http_info(**kwargs)

    def get_emissions_data_for_locations_by_time(
        self,
        location,
        **kwargs
    ):
        """Calculate the observed emission data by list of locations for a specified time period.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_emissions_data_for_locations_by_time(location, async_req=True)
        >>> result = thread.get()

        Args:
            location ([str]): String array of named locations

        Keyword Args:
            time (datetime): [Optional] Start time for the data query.. [optional]
            to_time (datetime): [Optional] End time for the data query.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EmissionsData]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['location'] = \
            location
        return self.get_emissions_data_for_locations_by_time_endpoint.call_with_http_info(**kwargs)

