# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "20.1.8",
                "commands": r"clang-cl",
                "args": r"",
                "linker args": r"",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.1.3",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "20.1.8",
                "commands": r"clang-cl",
                "args": r"",
                "linker args": r"",
            },
            "fortran": {
                "name": "llvm-flang",
                "linker": r"lld-link",
                "version": "20.1.8",
                "commands": r"flang",
                "args": r"",
                "linker args": r"",
            },
            "pythran": {
                "version": r"0.18.0",
                "include directory": r"..\..\..\..\Users\runneradmin\AppData\Local\Temp\build-env-zkzxs9g6\Lib\site-packages\pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"windows",
            },
            "build": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"windows",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "scipy-openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.29.dev",
                "detection method": "pkgconfig",
                "include directory": r"C:/Users/runneradmin/AppData/Local/Temp/cibw-run-eglzf0q6/cp313-win_arm64/build/venv/Lib/site-packages/scipy_openblas32/include",
                "lib directory": r"C:/Users/runneradmin/AppData/Local/Temp/cibw-run-eglzf0q6/cp313-win_arm64/build/venv/Lib/site-packages/scipy_openblas32/lib",
                "openblas configuration": r"OpenBLAS 0.3.29.dev NO_AFFINITY ARMV8 MAX_THREADS=4",
                "pc file directory": r"C:/a/scipy/scipy",
            },
            "lapack": {
                "name": "scipy-openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.29.dev",
                "detection method": "pkgconfig",
                "include directory": r"C:/Users/runneradmin/AppData/Local/Temp/cibw-run-eglzf0q6/cp313-win_arm64/build/venv/Lib/site-packages/scipy_openblas32/include",
                "lib directory": r"C:/Users/runneradmin/AppData/Local/Temp/cibw-run-eglzf0q6/cp313-win_arm64/build/venv/Lib/site-packages/scipy_openblas32/lib",
                "openblas configuration": r"OpenBLAS 0.3.29.dev NO_AFFINITY ARMV8 MAX_THREADS=4",
                "pc file directory": r"C:/a/scipy/scipy",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.1",
                "detection method": "config-tool",
                "include directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"C:\Users\runneradmin\AppData\Local\Temp\build-env-zkzxs9g6\Scripts\python.exe",
            "version": "3.13",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
