from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.ui_messages_item_artifacts_item import UiMessagesItemArtifactsItem
    from ..models.ui_messages_item_props import UiMessagesItemProps


T = TypeVar("T", bound="UiMessagesItem")


@_attrs_define
class UiMessagesItem:
    """
    Attributes:
        id (str):
        thread_id (Union[Unset, str]):
        component (Union[Unset, str]):
        props (Union[Unset, UiMessagesItemProps]):
        artifacts (Union[Unset, List['UiMessagesItemArtifactsItem']]):
    """

    id: str
    thread_id: Union[Unset, str] = UNSET
    component: Union[Unset, str] = UNSET
    props: Union[Unset, "UiMessagesItemProps"] = UNSET
    artifacts: Union[Unset, List["UiMessagesItemArtifactsItem"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        thread_id = self.thread_id

        component = self.component

        props: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.props, Unset):
            props = self.props.to_dict()

        artifacts: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.artifacts, Unset):
            artifacts = []
            for artifacts_item_data in self.artifacts:
                artifacts_item = artifacts_item_data.to_dict()
                artifacts.append(artifacts_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
            }
        )
        if thread_id is not UNSET:
            field_dict["thread_id"] = thread_id
        if component is not UNSET:
            field_dict["component"] = component
        if props is not UNSET:
            field_dict["props"] = props
        if artifacts is not UNSET:
            field_dict["artifacts"] = artifacts

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.ui_messages_item_artifacts_item import UiMessagesItemArtifactsItem
        from ..models.ui_messages_item_props import UiMessagesItemProps

        d = src_dict.copy()
        id = d.pop("id")

        thread_id = d.pop("thread_id", UNSET)

        component = d.pop("component", UNSET)

        _props = d.pop("props", UNSET)
        props: Union[Unset, UiMessagesItemProps]
        if isinstance(_props, Unset):
            props = UNSET
        else:
            props = UiMessagesItemProps.from_dict(_props)

        artifacts = []
        _artifacts = d.pop("artifacts", UNSET)
        for artifacts_item_data in _artifacts or []:
            artifacts_item = UiMessagesItemArtifactsItem.from_dict(artifacts_item_data)

            artifacts.append(artifacts_item)

        ui_messages_item = cls(
            id=id,
            thread_id=thread_id,
            component=component,
            props=props,
            artifacts=artifacts,
        )

        ui_messages_item.additional_properties = d
        return ui_messages_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
