import dynamodb = require('@aws-cdk/aws-dynamodb');
import lambda = require('@aws-cdk/aws-lambda');
export interface DynamoEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event
     * source at the time of invoking your function. Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range: Minimum value of 1. Maximum value of 1000.
     *
     * @default 100
     */
    readonly batchSize?: number;
    /**
     * Where to begin consuming the DynamoDB stream.
     */
    readonly startingPosition: lambda.StartingPosition;
}
/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 */
export declare class DynamoEventSource implements lambda.IEventSource {
    private readonly table;
    private readonly props;
    constructor(table: dynamodb.Table, props: DynamoEventSourceProps);
    bind(target: lambda.IFunction): void;
}
