import kinesis = require('@aws-cdk/aws-kinesis');
import lambda = require('@aws-cdk/aws-lambda');
export interface KinesisEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event
     * source at the time of invoking your function. Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range: Minimum value of 1. Maximum value of 10000.
     *
     * @default 100
     */
    readonly batchSize?: number;
    /**
     * Where to begin consuming the Kinesis stream.
     */
    readonly startingPosition: lambda.StartingPosition;
}
/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 */
export declare class KinesisEventSource implements lambda.IEventSource {
    readonly stream: kinesis.IStream;
    private readonly props;
    constructor(stream: kinesis.IStream, props: KinesisEventSourceProps);
    bind(target: lambda.IFunction): void;
}
