"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 */
class KinesisEventSource {
    constructor(stream, props) {
        this.stream = stream;
        this.props = props;
        if (this.props.batchSize !== undefined && (this.props.batchSize < 1 || this.props.batchSize > 10000)) {
            throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize})`);
        }
    }
    bind(target) {
        target.addEventSourceMapping(`KinesisEventSource:${this.stream.node.uniqueId}`, {
            batchSize: this.props.batchSize || 100,
            startingPosition: this.props.startingPosition,
            eventSourceArn: this.stream.streamArn,
        });
        this.stream.grantRead(target);
    }
}
exports.KinesisEventSource = KinesisEventSource;
//# sourceMappingURL=data:application/json;base64,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