"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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