"use strict";
const assert_1 = require("@aws-cdk/assert");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const events = require("../lib");
module.exports = {
    'minimal example'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FFB3F557C", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4FfooCA6F87E4" },
        }));
        test.done();
    },
    'disjoint routes'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        handler.addEventSource(new events.ApiEventSource('post', '/bar'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FFB3F557C", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "bar",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FFB3F557C", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4FfooCA6F87E4" },
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'POST',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4FbarDFB0F21B" },
        }));
        test.done();
    },
    "tree of routes"(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        handler.addEventSource(new events.ApiEventSource('post', '/foo/bar'));
        handler.addEventSource(new events.ApiEventSource('post', '/foo/bar/zoo'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FFB3F557C", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "bar",
            ParentId: { Ref: "MyFuncApiEventSourceA7A86A4FfooCA6F87E4" }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4FfooCA6F87E4" },
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'POST',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoobar028FFFDE" },
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hcGkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsNENBQXVEO0FBQ3ZELDhDQUErQztBQUMvQyxxQ0FBc0M7QUFFdEMsaUNBQWtDO0FBRWxDLGlCQUFTO0lBQ1AsaUJBQWlCLENBQUMsSUFBVTtRQUMxQixRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDOUIsTUFBTSxPQUFPLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDbkQsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQztZQUNoQyxPQUFPLEVBQUUsZUFBZTtZQUN4QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNO1NBQy9CLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxPQUFPLENBQUMsY0FBYyxDQUFDLElBQUksTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUVqRSxPQUFPO1FBQ1AsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLDJCQUEyQixFQUFFO1lBQ3pELFFBQVEsRUFBRSxLQUFLO1lBQ2YsUUFBUSxFQUFFLEVBQUUsWUFBWSxFQUFFLENBQUUsc0NBQXNDLEVBQUUsZ0JBQWdCLENBQUUsRUFBRTtTQUN6RixDQUFDLENBQUMsQ0FBQztRQUVKLGVBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQyx5QkFBeUIsRUFBRTtZQUN2RCxVQUFVLEVBQUUsS0FBSztZQUNqQixVQUFVLEVBQUUsRUFBRSxHQUFHLEVBQUUseUNBQXlDLEVBQUU7U0FDL0QsQ0FBQyxDQUFDLENBQUM7UUFFSixJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsaUJBQWlCLENBQUMsSUFBVTtRQUMxQixRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDOUIsTUFBTSxPQUFPLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDbkQsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQztZQUNoQyxPQUFPLEVBQUUsZUFBZTtZQUN4QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNO1NBQy9CLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxPQUFPLENBQUMsY0FBYyxDQUFDLElBQUksTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUNqRSxPQUFPLENBQUMsY0FBYyxDQUFDLElBQUksTUFBTSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUVsRSxPQUFPO1FBQ1AsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLDJCQUEyQixFQUFFO1lBQ3pELFFBQVEsRUFBRSxLQUFLO1lBQ2YsUUFBUSxFQUFFLEVBQUUsWUFBWSxFQUFFLENBQUUsc0NBQXNDLEVBQUUsZ0JBQWdCLENBQUUsRUFBRTtTQUN6RixDQUFDLENBQUMsQ0FBQztRQUVKLGVBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQywyQkFBMkIsRUFBRTtZQUN6RCxRQUFRLEVBQUUsS0FBSztZQUNmLFFBQVEsRUFBRSxFQUFFLFlBQVksRUFBRSxDQUFFLHNDQUFzQyxFQUFFLGdCQUFnQixDQUFFLEVBQUU7U0FDekYsQ0FBQyxDQUFDLENBQUM7UUFFSixlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMseUJBQXlCLEVBQUU7WUFDdkQsVUFBVSxFQUFFLEtBQUs7WUFDakIsVUFBVSxFQUFFLEVBQUUsR0FBRyxFQUFFLHlDQUF5QyxFQUFFO1NBQy9ELENBQUMsQ0FBQyxDQUFDO1FBRUosZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLHlCQUF5QixFQUFFO1lBQ3ZELFVBQVUsRUFBRSxNQUFNO1lBQ2xCLFVBQVUsRUFBRSxFQUFFLEdBQUcsRUFBRSx5Q0FBeUMsRUFBRTtTQUMvRCxDQUFDLENBQUMsQ0FBQztRQUVKLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxnQkFBZ0IsQ0FBQyxJQUFVO1FBQ3pCLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUM5QixNQUFNLE9BQU8sR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtZQUNuRCxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDO1lBQ2hDLE9BQU8sRUFBRSxlQUFlO1lBQ3hCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU07U0FDL0IsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ2pFLE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxVQUFVLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBRTFFLE9BQU87UUFDUCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsMkJBQTJCLEVBQUU7WUFDekQsUUFBUSxFQUFFLEtBQUs7WUFDZixRQUFRLEVBQUUsRUFBRSxZQUFZLEVBQUUsQ0FBRSxzQ0FBc0MsRUFBRSxnQkFBZ0IsQ0FBRSxFQUFFO1NBQ3pGLENBQUMsQ0FBQyxDQUFDO1FBRUosZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLDJCQUEyQixFQUFFO1lBQ3pELFFBQVEsRUFBRSxLQUFLO1lBQ2YsUUFBUSxFQUFFLEVBQUUsR0FBRyxFQUFFLHlDQUF5QyxFQUFFO1NBQzdELENBQUMsQ0FBQyxDQUFDO1FBRUosZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLHlCQUF5QixFQUFFO1lBQ3ZELFVBQVUsRUFBRSxLQUFLO1lBQ2pCLFVBQVUsRUFBRSxFQUFFLEdBQUcsRUFBRSx5Q0FBeUMsRUFBRTtTQUMvRCxDQUFDLENBQUMsQ0FBQztRQUVKLGVBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQyx5QkFBeUIsRUFBRTtZQUN2RCxVQUFVLEVBQUUsTUFBTTtZQUNsQixVQUFVLEVBQUUsRUFBRSxHQUFHLEVBQUUsNENBQTRDLEVBQUU7U0FDbEUsQ0FBQyxDQUFDLENBQUM7UUFFSixJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBQ0YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGV4cGVjdCwgaGF2ZVJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCBsYW1iZGEgPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtbGFtYmRhJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCBldmVudHMgPSByZXF1aXJlKCcuLi9saWInKTtcblxuZXhwb3J0ID0ge1xuICAnbWluaW1hbCBleGFtcGxlJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcbiAgICBjb25zdCBoYW5kbGVyID0gbmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgJ015RnVuYycsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmlubGluZSgnYm9vbScpLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTLFxuICAgIH0pO1xuXG4gICAgLy8gV0hFTlxuICAgIGhhbmRsZXIuYWRkRXZlbnRTb3VyY2UobmV3IGV2ZW50cy5BcGlFdmVudFNvdXJjZSgnZ2V0JywgJy9mb28nKSk7XG5cbiAgICAvLyBUSEVOXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheTo6UmVzb3VyY2UnLCB7XG4gICAgICBQYXRoUGFydDogXCJmb29cIixcbiAgICAgIFBhcmVudElkOiB7IFwiRm46OkdldEF0dFwiOiBbIFwiTXlGdW5jQXBpRXZlbnRTb3VyY2VBN0E4NkE0RkZCM0Y1NTdDXCIsIFwiUm9vdFJlc291cmNlSWRcIiBdIH1cbiAgICB9KSk7XG5cbiAgICBleHBlY3Qoc3RhY2spLnRvKGhhdmVSZXNvdXJjZSgnQVdTOjpBcGlHYXRld2F5OjpNZXRob2QnLCB7XG4gICAgICBIdHRwTWV0aG9kOiAnR0VUJyxcbiAgICAgIFJlc291cmNlSWQ6IHsgUmVmOiBcIk15RnVuY0FwaUV2ZW50U291cmNlQTdBODZBNEZmb29DQTZGODdFNFwiIH0sXG4gICAgfSkpO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2Rpc2pvaW50IHJvdXRlcycodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG4gICAgY29uc3QgaGFuZGxlciA9IG5ldyBsYW1iZGEuRnVuY3Rpb24oc3RhY2ssICdNeUZ1bmMnLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5pbmxpbmUoJ2Jvb20nKSxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5PREVKUyxcbiAgICB9KTtcblxuICAgIC8vIFdIRU5cbiAgICBoYW5kbGVyLmFkZEV2ZW50U291cmNlKG5ldyBldmVudHMuQXBpRXZlbnRTb3VyY2UoJ2dldCcsICcvZm9vJykpO1xuICAgIGhhbmRsZXIuYWRkRXZlbnRTb3VyY2UobmV3IGV2ZW50cy5BcGlFdmVudFNvdXJjZSgncG9zdCcsICcvYmFyJykpO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkFwaUdhdGV3YXk6OlJlc291cmNlJywge1xuICAgICAgUGF0aFBhcnQ6IFwiZm9vXCIsXG4gICAgICBQYXJlbnRJZDogeyBcIkZuOjpHZXRBdHRcIjogWyBcIk15RnVuY0FwaUV2ZW50U291cmNlQTdBODZBNEZGQjNGNTU3Q1wiLCBcIlJvb3RSZXNvdXJjZUlkXCIgXSB9XG4gICAgfSkpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheTo6UmVzb3VyY2UnLCB7XG4gICAgICBQYXRoUGFydDogXCJiYXJcIixcbiAgICAgIFBhcmVudElkOiB7IFwiRm46OkdldEF0dFwiOiBbIFwiTXlGdW5jQXBpRXZlbnRTb3VyY2VBN0E4NkE0RkZCM0Y1NTdDXCIsIFwiUm9vdFJlc291cmNlSWRcIiBdIH1cbiAgICB9KSk7XG5cbiAgICBleHBlY3Qoc3RhY2spLnRvKGhhdmVSZXNvdXJjZSgnQVdTOjpBcGlHYXRld2F5OjpNZXRob2QnLCB7XG4gICAgICBIdHRwTWV0aG9kOiAnR0VUJyxcbiAgICAgIFJlc291cmNlSWQ6IHsgUmVmOiBcIk15RnVuY0FwaUV2ZW50U291cmNlQTdBODZBNEZmb29DQTZGODdFNFwiIH0sXG4gICAgfSkpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheTo6TWV0aG9kJywge1xuICAgICAgSHR0cE1ldGhvZDogJ1BPU1QnLFxuICAgICAgUmVzb3VyY2VJZDogeyBSZWY6IFwiTXlGdW5jQXBpRXZlbnRTb3VyY2VBN0E4NkE0RmJhckRGQjBGMjFCXCIgfSxcbiAgICB9KSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICBcInRyZWUgb2Ygcm91dGVzXCIodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG4gICAgY29uc3QgaGFuZGxlciA9IG5ldyBsYW1iZGEuRnVuY3Rpb24oc3RhY2ssICdNeUZ1bmMnLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5pbmxpbmUoJ2Jvb20nKSxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5PREVKUyxcbiAgICB9KTtcblxuICAgIC8vIFdIRU5cbiAgICBoYW5kbGVyLmFkZEV2ZW50U291cmNlKG5ldyBldmVudHMuQXBpRXZlbnRTb3VyY2UoJ2dldCcsICcvZm9vJykpO1xuICAgIGhhbmRsZXIuYWRkRXZlbnRTb3VyY2UobmV3IGV2ZW50cy5BcGlFdmVudFNvdXJjZSgncG9zdCcsICcvZm9vL2JhcicpKTtcbiAgICBoYW5kbGVyLmFkZEV2ZW50U291cmNlKG5ldyBldmVudHMuQXBpRXZlbnRTb3VyY2UoJ3Bvc3QnLCAnL2Zvby9iYXIvem9vJykpO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkFwaUdhdGV3YXk6OlJlc291cmNlJywge1xuICAgICAgUGF0aFBhcnQ6IFwiZm9vXCIsXG4gICAgICBQYXJlbnRJZDogeyBcIkZuOjpHZXRBdHRcIjogWyBcIk15RnVuY0FwaUV2ZW50U291cmNlQTdBODZBNEZGQjNGNTU3Q1wiLCBcIlJvb3RSZXNvdXJjZUlkXCIgXSB9XG4gICAgfSkpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheTo6UmVzb3VyY2UnLCB7XG4gICAgICBQYXRoUGFydDogXCJiYXJcIixcbiAgICAgIFBhcmVudElkOiB7IFJlZjogXCJNeUZ1bmNBcGlFdmVudFNvdXJjZUE3QTg2QTRGZm9vQ0E2Rjg3RTRcIiB9XG4gICAgfSkpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheTo6TWV0aG9kJywge1xuICAgICAgSHR0cE1ldGhvZDogJ0dFVCcsXG4gICAgICBSZXNvdXJjZUlkOiB7IFJlZjogXCJNeUZ1bmNBcGlFdmVudFNvdXJjZUE3QTg2QTRGZm9vQ0E2Rjg3RTRcIiB9LFxuICAgIH0pKTtcblxuICAgIGV4cGVjdChzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkFwaUdhdGV3YXk6Ok1ldGhvZCcsIHtcbiAgICAgIEh0dHBNZXRob2Q6ICdQT1NUJyxcbiAgICAgIFJlc291cmNlSWQ6IHsgUmVmOiBcIk15RnVuY0FwaUV2ZW50U291cmNlQTdBODZBNEZmb29iYXIwMjhGRkZERVwiIH0sXG4gICAgfSkpO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH1cbn07Il19