"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * An esbuild installation
 */
class EsbuildInstallation {
    static detect() {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersion('esbuild');
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const esbuild = child_process_1.spawnSync('esbuild', ['--version']);
            if (esbuild.status === 0 && !esbuild.error) {
                return {
                    isLocal: false,
                    version: esbuild.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.EsbuildInstallation = EsbuildInstallation;
//# sourceMappingURL=data:application/json;base64,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