import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#always_log_errors ApiManagementDiagnostic#always_log_errors}.
     *
     * @stability stable
     */
    readonly alwaysLogErrors?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#api_management_logger_id ApiManagementDiagnostic#api_management_logger_id}.
     *
     * @stability stable
     */
    readonly apiManagementLoggerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#api_management_name ApiManagementDiagnostic#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#enabled ApiManagementDiagnostic#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#http_correlation_protocol ApiManagementDiagnostic#http_correlation_protocol}.
     *
     * @stability stable
     */
    readonly httpCorrelationProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#identifier ApiManagementDiagnostic#identifier}.
     *
     * @stability stable
     */
    readonly identifier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#log_client_ip ApiManagementDiagnostic#log_client_ip}.
     *
     * @stability stable
     */
    readonly logClientIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#operation_name_format ApiManagementDiagnostic#operation_name_format}.
     *
     * @stability stable
     */
    readonly operationNameFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#resource_group_name ApiManagementDiagnostic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#sampling_percentage ApiManagementDiagnostic#sampling_percentage}.
     *
     * @stability stable
     */
    readonly samplingPercentage?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#verbosity ApiManagementDiagnostic#verbosity}.
     *
     * @stability stable
     */
    readonly verbosity?: string;
    /**
     * backend_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#backend_request ApiManagementDiagnostic#backend_request}
     *
     * @stability stable
     */
    readonly backendRequest?: ApiManagementDiagnosticBackendRequest;
    /**
     * backend_response block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#backend_response ApiManagementDiagnostic#backend_response}
     *
     * @stability stable
     */
    readonly backendResponse?: ApiManagementDiagnosticBackendResponse;
    /**
     * frontend_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#frontend_request ApiManagementDiagnostic#frontend_request}
     *
     * @stability stable
     */
    readonly frontendRequest?: ApiManagementDiagnosticFrontendRequest;
    /**
     * frontend_response block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#frontend_response ApiManagementDiagnostic#frontend_response}
     *
     * @stability stable
     */
    readonly frontendResponse?: ApiManagementDiagnosticFrontendResponse;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#timeouts ApiManagementDiagnostic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementDiagnosticTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendRequestDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendRequestDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendRequestDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers ApiManagementDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#query_params ApiManagementDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[];
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementDiagnosticBackendRequestDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticBackendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticBackendRequestDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementDiagnosticBackendRequestDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendRequest {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#body_bytes ApiManagementDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers_to_log ApiManagementDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#data_masking ApiManagementDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementDiagnosticBackendRequestDataMasking;
}
export declare function apiManagementDiagnosticBackendRequestToTerraform(struct?: ApiManagementDiagnosticBackendRequestOutputReference | ApiManagementDiagnosticBackendRequest): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticBackendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticBackendRequest | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticBackendRequest | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementDiagnosticBackendRequestDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementDiagnosticBackendRequestDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendResponseDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendResponseDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendResponseDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers ApiManagementDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#query_params ApiManagementDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[];
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementDiagnosticBackendResponseDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticBackendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticBackendResponseDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementDiagnosticBackendResponseDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticBackendResponse {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#body_bytes ApiManagementDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers_to_log ApiManagementDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#data_masking ApiManagementDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementDiagnosticBackendResponseDataMasking;
}
export declare function apiManagementDiagnosticBackendResponseToTerraform(struct?: ApiManagementDiagnosticBackendResponseOutputReference | ApiManagementDiagnosticBackendResponse): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticBackendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticBackendResponse | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticBackendResponse | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementDiagnosticBackendResponseDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementDiagnosticBackendResponseDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendRequestDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendRequestDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers ApiManagementDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#query_params ApiManagementDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[];
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementDiagnosticFrontendRequestDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticFrontendRequestDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendRequest {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#body_bytes ApiManagementDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers_to_log ApiManagementDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#data_masking ApiManagementDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementDiagnosticFrontendRequestDataMasking;
}
export declare function apiManagementDiagnosticFrontendRequestToTerraform(struct?: ApiManagementDiagnosticFrontendRequestOutputReference | ApiManagementDiagnosticFrontendRequest): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticFrontendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticFrontendRequest | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticFrontendRequest | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementDiagnosticFrontendRequestDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendResponseDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#mode ApiManagementDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#value ApiManagementDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendResponseDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers ApiManagementDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#query_params ApiManagementDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[];
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementDiagnosticFrontendResponseDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticFrontendResponseDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticFrontendResponse {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#body_bytes ApiManagementDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#headers_to_log ApiManagementDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#data_masking ApiManagementDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementDiagnosticFrontendResponseDataMasking;
}
export declare function apiManagementDiagnosticFrontendResponseToTerraform(struct?: ApiManagementDiagnosticFrontendResponseOutputReference | ApiManagementDiagnosticFrontendResponse): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticFrontendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticFrontendResponse | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticFrontendResponse | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementDiagnosticFrontendResponseDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementDiagnosticTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#create ApiManagementDiagnostic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#delete ApiManagementDiagnostic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#read ApiManagementDiagnostic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html#update ApiManagementDiagnostic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementDiagnosticTimeoutsToTerraform(struct?: ApiManagementDiagnosticTimeoutsOutputReference | ApiManagementDiagnosticTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementDiagnosticTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementDiagnosticTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementDiagnosticTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html azurerm_api_management_diagnostic}.
 *
 * @stability stable
 */
export declare class ApiManagementDiagnostic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic.html azurerm_api_management_diagnostic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementDiagnosticConfig);
    private _alwaysLogErrors?;
    /**
     * @stability stable
     */
    get alwaysLogErrors(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysLogErrors(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysLogErrors(): void;
    /**
     * @stability stable
     */
    get alwaysLogErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiManagementLoggerId?;
    /**
     * @stability stable
     */
    get apiManagementLoggerId(): string;
    /**
     * @stability stable
     */
    set apiManagementLoggerId(value: string);
    /**
     * @stability stable
     */
    get apiManagementLoggerIdInput(): string | undefined;
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpCorrelationProtocol?;
    /**
     * @stability stable
     */
    get httpCorrelationProtocol(): string;
    /**
     * @stability stable
     */
    set httpCorrelationProtocol(value: string);
    /**
     * @stability stable
     */
    resetHttpCorrelationProtocol(): void;
    /**
     * @stability stable
     */
    get httpCorrelationProtocolInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _identifier?;
    /**
     * @stability stable
     */
    get identifier(): string;
    /**
     * @stability stable
     */
    set identifier(value: string);
    /**
     * @stability stable
     */
    get identifierInput(): string | undefined;
    private _logClientIp?;
    /**
     * @stability stable
     */
    get logClientIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logClientIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLogClientIp(): void;
    /**
     * @stability stable
     */
    get logClientIpInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNameFormat?;
    /**
     * @stability stable
     */
    get operationNameFormat(): string;
    /**
     * @stability stable
     */
    set operationNameFormat(value: string);
    /**
     * @stability stable
     */
    resetOperationNameFormat(): void;
    /**
     * @stability stable
     */
    get operationNameFormatInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _samplingPercentage?;
    /**
     * @stability stable
     */
    get samplingPercentage(): number;
    /**
     * @stability stable
     */
    set samplingPercentage(value: number);
    /**
     * @stability stable
     */
    resetSamplingPercentage(): void;
    /**
     * @stability stable
     */
    get samplingPercentageInput(): number | undefined;
    private _verbosity?;
    /**
     * @stability stable
     */
    get verbosity(): string;
    /**
     * @stability stable
     */
    set verbosity(value: string);
    /**
     * @stability stable
     */
    resetVerbosity(): void;
    /**
     * @stability stable
     */
    get verbosityInput(): string | undefined;
    private _backendRequest;
    /**
     * @stability stable
     */
    get backendRequest(): ApiManagementDiagnosticBackendRequestOutputReference;
    /**
     * @stability stable
     */
    putBackendRequest(value: ApiManagementDiagnosticBackendRequest): void;
    /**
     * @stability stable
     */
    resetBackendRequest(): void;
    /**
     * @stability stable
     */
    get backendRequestInput(): ApiManagementDiagnosticBackendRequest | undefined;
    private _backendResponse;
    /**
     * @stability stable
     */
    get backendResponse(): ApiManagementDiagnosticBackendResponseOutputReference;
    /**
     * @stability stable
     */
    putBackendResponse(value: ApiManagementDiagnosticBackendResponse): void;
    /**
     * @stability stable
     */
    resetBackendResponse(): void;
    /**
     * @stability stable
     */
    get backendResponseInput(): ApiManagementDiagnosticBackendResponse | undefined;
    private _frontendRequest;
    /**
     * @stability stable
     */
    get frontendRequest(): ApiManagementDiagnosticFrontendRequestOutputReference;
    /**
     * @stability stable
     */
    putFrontendRequest(value: ApiManagementDiagnosticFrontendRequest): void;
    /**
     * @stability stable
     */
    resetFrontendRequest(): void;
    /**
     * @stability stable
     */
    get frontendRequestInput(): ApiManagementDiagnosticFrontendRequest | undefined;
    private _frontendResponse;
    /**
     * @stability stable
     */
    get frontendResponse(): ApiManagementDiagnosticFrontendResponseOutputReference;
    /**
     * @stability stable
     */
    putFrontendResponse(value: ApiManagementDiagnosticFrontendResponse): void;
    /**
     * @stability stable
     */
    resetFrontendResponse(): void;
    /**
     * @stability stable
     */
    get frontendResponseInput(): ApiManagementDiagnosticFrontendResponse | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementDiagnosticTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementDiagnosticTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementDiagnosticTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
