import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBillingMpaAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html#billing_account_name DataAzurermBillingMpaAccountScope#billing_account_name}.
     *
     * @stability stable
     */
    readonly billingAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html#customer_name DataAzurermBillingMpaAccountScope#customer_name}.
     *
     * @stability stable
     */
    readonly customerName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html#timeouts DataAzurermBillingMpaAccountScope#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBillingMpaAccountScopeTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBillingMpaAccountScopeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html#read DataAzurermBillingMpaAccountScope#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBillingMpaAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingMpaAccountScopeTimeoutsOutputReference | DataAzurermBillingMpaAccountScopeTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBillingMpaAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBillingMpaAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBillingMpaAccountScopeTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html azurerm_billing_mpa_account_scope}.
 *
 * @stability stable
 */
export declare class DataAzurermBillingMpaAccountScope extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope.html azurerm_billing_mpa_account_scope} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBillingMpaAccountScopeConfig);
    private _billingAccountName?;
    /**
     * @stability stable
     */
    get billingAccountName(): string;
    /**
     * @stability stable
     */
    set billingAccountName(value: string);
    /**
     * @stability stable
     */
    get billingAccountNameInput(): string | undefined;
    private _customerName?;
    /**
     * @stability stable
     */
    get customerName(): string;
    /**
     * @stability stable
     */
    set customerName(value: string);
    /**
     * @stability stable
     */
    get customerNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBillingMpaAccountScopeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBillingMpaAccountScopeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBillingMpaAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
