import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetappVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#account_name NetappVolume#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#create_from_snapshot_resource_id NetappVolume#create_from_snapshot_resource_id}.
     *
     * @stability stable
     */
    readonly createFromSnapshotResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#location NetappVolume#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#name NetappVolume#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#pool_name NetappVolume#pool_name}.
     *
     * @stability stable
     */
    readonly poolName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#protocols NetappVolume#protocols}.
     *
     * @stability stable
     */
    readonly protocols?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#resource_group_name NetappVolume#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#security_style NetappVolume#security_style}.
     *
     * @stability stable
     */
    readonly securityStyle?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#service_level NetappVolume#service_level}.
     *
     * @stability stable
     */
    readonly serviceLevel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#snapshot_directory_visible NetappVolume#snapshot_directory_visible}.
     *
     * @stability stable
     */
    readonly snapshotDirectoryVisible?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#storage_quota_in_gb NetappVolume#storage_quota_in_gb}.
     *
     * @stability stable
     */
    readonly storageQuotaInGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#subnet_id NetappVolume#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#tags NetappVolume#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#volume_path NetappVolume#volume_path}.
     *
     * @stability stable
     */
    readonly volumePath: string;
    /**
     * data_protection_replication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#data_protection_replication NetappVolume#data_protection_replication}
     *
     * @stability stable
     */
    readonly dataProtectionReplication?: NetappVolumeDataProtectionReplication;
    /**
     * export_policy_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#export_policy_rule NetappVolume#export_policy_rule}
     *
     * @stability stable
     */
    readonly exportPolicyRule?: NetappVolumeExportPolicyRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#timeouts NetappVolume#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetappVolumeTimeouts;
}
/**
 * @stability stable
 */
export interface NetappVolumeDataProtectionReplication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#endpoint_type NetappVolume#endpoint_type}.
     *
     * @stability stable
     */
    readonly endpointType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#remote_volume_location NetappVolume#remote_volume_location}.
     *
     * @stability stable
     */
    readonly remoteVolumeLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#remote_volume_resource_id NetappVolume#remote_volume_resource_id}.
     *
     * @stability stable
     */
    readonly remoteVolumeResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#replication_frequency NetappVolume#replication_frequency}.
     *
     * @stability stable
     */
    readonly replicationFrequency: string;
}
export declare function netappVolumeDataProtectionReplicationToTerraform(struct?: NetappVolumeDataProtectionReplicationOutputReference | NetappVolumeDataProtectionReplication): any;
/**
 * @stability stable
 */
export declare class NetappVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappVolumeDataProtectionReplication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappVolumeDataProtectionReplication | undefined);
    private _endpointType?;
    /**
     * @stability stable
     */
    get endpointType(): string;
    /**
     * @stability stable
     */
    set endpointType(value: string);
    /**
     * @stability stable
     */
    resetEndpointType(): void;
    /**
     * @stability stable
     */
    get endpointTypeInput(): string | undefined;
    private _remoteVolumeLocation?;
    /**
     * @stability stable
     */
    get remoteVolumeLocation(): string;
    /**
     * @stability stable
     */
    set remoteVolumeLocation(value: string);
    /**
     * @stability stable
     */
    get remoteVolumeLocationInput(): string | undefined;
    private _remoteVolumeResourceId?;
    /**
     * @stability stable
     */
    get remoteVolumeResourceId(): string;
    /**
     * @stability stable
     */
    set remoteVolumeResourceId(value: string);
    /**
     * @stability stable
     */
    get remoteVolumeResourceIdInput(): string | undefined;
    private _replicationFrequency?;
    /**
     * @stability stable
     */
    get replicationFrequency(): string;
    /**
     * @stability stable
     */
    set replicationFrequency(value: string);
    /**
     * @stability stable
     */
    get replicationFrequencyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetappVolumeExportPolicyRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#allowed_clients NetappVolume#allowed_clients}.
     *
     * @stability stable
     */
    readonly allowedClients: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#cifs_enabled NetappVolume#cifs_enabled}.
     *
     * @stability stable
     */
    readonly cifsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#nfsv3_enabled NetappVolume#nfsv3_enabled}.
     *
     * @stability stable
     */
    readonly nfsv3Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#nfsv4_enabled NetappVolume#nfsv4_enabled}.
     *
     * @stability stable
     */
    readonly nfsv4Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#protocols_enabled NetappVolume#protocols_enabled}.
     *
     * @stability stable
     */
    readonly protocolsEnabled?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#root_access_enabled NetappVolume#root_access_enabled}.
     *
     * @stability stable
     */
    readonly rootAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#rule_index NetappVolume#rule_index}.
     *
     * @stability stable
     */
    readonly ruleIndex: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#unix_read_only NetappVolume#unix_read_only}.
     *
     * @stability stable
     */
    readonly unixReadOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#unix_read_write NetappVolume#unix_read_write}.
     *
     * @stability stable
     */
    readonly unixReadWrite?: boolean | cdktf.IResolvable;
}
export declare function netappVolumeExportPolicyRuleToTerraform(struct?: NetappVolumeExportPolicyRule): any;
/**
 * @stability stable
 */
export interface NetappVolumeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#create NetappVolume#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#delete NetappVolume#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#read NetappVolume#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html#update NetappVolume#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function netappVolumeTimeoutsToTerraform(struct?: NetappVolumeTimeoutsOutputReference | NetappVolumeTimeouts): any;
/**
 * @stability stable
 */
export declare class NetappVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappVolumeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappVolumeTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html azurerm_netapp_volume}.
 *
 * @stability stable
 */
export declare class NetappVolume extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_volume.html azurerm_netapp_volume} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetappVolumeConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _createFromSnapshotResourceId?;
    /**
     * @stability stable
     */
    get createFromSnapshotResourceId(): string;
    /**
     * @stability stable
     */
    set createFromSnapshotResourceId(value: string);
    /**
     * @stability stable
     */
    resetCreateFromSnapshotResourceId(): void;
    /**
     * @stability stable
     */
    get createFromSnapshotResourceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get mountIpAddresses(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolName?;
    /**
     * @stability stable
     */
    get poolName(): string;
    /**
     * @stability stable
     */
    set poolName(value: string);
    /**
     * @stability stable
     */
    get poolNameInput(): string | undefined;
    private _protocols?;
    /**
     * @stability stable
     */
    get protocols(): string[];
    /**
     * @stability stable
     */
    set protocols(value: string[]);
    /**
     * @stability stable
     */
    resetProtocols(): void;
    /**
     * @stability stable
     */
    get protocolsInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _securityStyle?;
    /**
     * @stability stable
     */
    get securityStyle(): string;
    /**
     * @stability stable
     */
    set securityStyle(value: string);
    /**
     * @stability stable
     */
    resetSecurityStyle(): void;
    /**
     * @stability stable
     */
    get securityStyleInput(): string | undefined;
    private _serviceLevel?;
    /**
     * @stability stable
     */
    get serviceLevel(): string;
    /**
     * @stability stable
     */
    set serviceLevel(value: string);
    /**
     * @stability stable
     */
    get serviceLevelInput(): string | undefined;
    private _snapshotDirectoryVisible?;
    /**
     * @stability stable
     */
    get snapshotDirectoryVisible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set snapshotDirectoryVisible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSnapshotDirectoryVisible(): void;
    /**
     * @stability stable
     */
    get snapshotDirectoryVisibleInput(): boolean | cdktf.IResolvable | undefined;
    private _storageQuotaInGb?;
    /**
     * @stability stable
     */
    get storageQuotaInGb(): number;
    /**
     * @stability stable
     */
    set storageQuotaInGb(value: number);
    /**
     * @stability stable
     */
    get storageQuotaInGbInput(): number | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _volumePath?;
    /**
     * @stability stable
     */
    get volumePath(): string;
    /**
     * @stability stable
     */
    set volumePath(value: string);
    /**
     * @stability stable
     */
    get volumePathInput(): string | undefined;
    private _dataProtectionReplication;
    /**
     * @stability stable
     */
    get dataProtectionReplication(): NetappVolumeDataProtectionReplicationOutputReference;
    /**
     * @stability stable
     */
    putDataProtectionReplication(value: NetappVolumeDataProtectionReplication): void;
    /**
     * @stability stable
     */
    resetDataProtectionReplication(): void;
    /**
     * @stability stable
     */
    get dataProtectionReplicationInput(): NetappVolumeDataProtectionReplication | undefined;
    private _exportPolicyRule?;
    /**
     * @stability stable
     */
    get exportPolicyRule(): NetappVolumeExportPolicyRule[];
    /**
     * @stability stable
     */
    set exportPolicyRule(value: NetappVolumeExportPolicyRule[]);
    /**
     * @stability stable
     */
    resetExportPolicyRule(): void;
    /**
     * @stability stable
     */
    get exportPolicyRuleInput(): NetappVolumeExportPolicyRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetappVolumeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetappVolumeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetappVolumeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
