import { IUserPool, IUserPoolClient } from 'aws-cdk-lib/aws-cognito';
import { IResource, Resource } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { IPolicyStore } from './policy-store';
export interface CognitoGroupConfiguration {
    /**
     * The name of the schema entity type that's mapped to the user pool group
     */
    readonly groupEntityType: string;
}
export interface CognitoUserPoolConfiguration {
    /**
     * Client identifiers.
     *
     * @default - empty list.
     */
    readonly clientIds?: string[];
    /**
     * Cognito Group Configuration
     *
     * @default - no Cognito Group configuration provided
     */
    readonly groupConfiguration?: CognitoGroupConfiguration;
    /**
     * Cognito User Pool.
     *
     * @default - no Cognito User Pool
     */
    readonly userPool: IUserPool;
}
export interface IdentitySourceConfiguration {
    /**
     * Cognito User Pool Configuration.
     *
     * @attribute
     */
    readonly cognitoUserPoolConfiguration: CognitoUserPoolConfiguration;
}
export interface IIdentitySource extends IResource {
    /**
     * Identity Source identifier.
     *
     * @attribute
     */
    readonly identitySourceId: string;
}
declare abstract class IdentitySourceBase extends Resource implements IIdentitySource {
    abstract readonly identitySourceId: string;
}
export interface IdentitySourceAttributes {
    /**
     * The identity Source identifier
     *
     * @attribute
     */
    readonly identitySourceId: string;
}
export interface IdentitySourceProps {
    /**
     *  Identity Source configuration.
     */
    readonly configuration: IdentitySourceConfiguration;
    /**
     * Policy Store in which you want to store this identity source
     *
     */
    readonly policyStore: IPolicyStore;
    /**
     * Principal entity type
     *
     * @default - No principal entity type for the identity source.
     */
    readonly principalEntityType?: string;
}
export declare class IdentitySource extends IdentitySourceBase {
    /**
     * Creates Identity Source from its attributes
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs An `IdentitySourceAttributes` object.
     */
    static fromIdentitySourceAttributes(scope: Construct, id: string, attrs: IdentitySourceAttributes): IIdentitySource;
    /**
     * Create an Identity Source from its identifier
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param identitySourceId The Identity Source identifier.
     */
    static fromIdentitySourceId(scope: Construct, id: string, identitySourceId: string): IIdentitySource;
    private readonly identitySource;
    readonly clientIds: string[];
    readonly discoveryUrl: string;
    readonly identitySourceId: string;
    readonly openIdIssuer: string;
    readonly userPoolArn: string;
    readonly cognitoGroupEntityType?: string;
    readonly policyStore: IPolicyStore;
    constructor(scope: Construct, id: string, props: IdentitySourceProps);
    /**
     * Add a User Pool Client
     *
     * @param userPoolClient The User Pool Client Construct.
     */
    addUserPoolClient(userPoolClient: IUserPoolClient): void;
}
export {};
