#!/usr/bin/env python3
"""
TSK Class Test - Test using TSK class instead of TSKParser
"""

import asyncio
import json
from tsk import TSK

async def test_tsk_class():
    """Test the TSK class to see if it has the execute methods"""
    print("=== TSK Class Method Test ===")
    
    # Create TSK instance
    tsk_content = """
test {
    value = "hello world"
}
"""
    
    tsk = TSK.from_string(tsk_content)
    
    print("TSK class methods:")
    execute_methods = [method for method in dir(tsk) if 'execute' in method]
    print(f"Execute methods found: {execute_methods}")
    
    # Test if we have access to the parser
    print(f"\nParser available: {hasattr(tsk, '_parser')}")
    if hasattr(tsk, '_parser'):
        parser = tsk._parser
        print(f"Parser methods: {[m for m in dir(parser) if 'execute' in m]}")
        
        # Test if parser has the methods
        if hasattr(parser, 'execute_operator'):
            print("✅ execute_operator found in parser!")
            
            # Test a basic operator
            try:
                result = await parser.execute_operator('cache', '@cache("60s", "test")', {})
                print(f"Cache operator result: {result}")
            except Exception as e:
                print(f"Cache operator error: {e}")
            
            # Test an advanced operator
            try:
                result = await parser.execute_operator('graphql', '@graphql("{ hello }")', {})
                print(f"GraphQL operator result: {result}")
            except Exception as e:
                print(f"GraphQL operator error: {e}")
                
        else:
            print("❌ execute_operator not found in parser")

if __name__ == "__main__":
    asyncio.run(test_tsk_class()) 