"""
TuskLang Python SDK - Enterprise Module
Production-quality enterprise features for Fortune 500 deployment readiness
"""

from .compliance.compliance_framework import (
    ComplianceFrameworkEngine,
    ComplianceRegulation,
    ComplianceStatus,
    ViolationSeverity,
    AuditEventType,
    ComplianceRule,
    ComplianceViolation,
    AuditEvent,
    PIIDataClassification
)

from .multitenancy.tenant_manager import (
    MultiTenantManager,
    Tenant,
    TenantStatus,
    TenantTier,
    IsolationLevel,
    ResourceType,
    ResourceQuota,
    TenantConfiguration,
    TenantProvisioningTask,
    UsageMetrics
)

from .packaging.package_distributor import (
    PackageDistributor,
    PackageEcosystem,
    PackageStatus,
    PackageVersion,
    PackageMetadata,
    PackageArtifact,
    DistributionTarget
)

from .identity.identity_manager import (
    EnterpriseIdentityManager,
    IdentityProvider,
    AuthenticationMethod,
    PermissionLevel,
    Role,
    User,
    Session,
    SAMLConfig,
    LDAPConfig
)

from .governance.data_governance import (
    DataGovernanceEngine,
    DataClassification,
    PrivacyRegulation,
    DataCategory,
    ConsentStatus,
    RetentionAction,
    DataAsset,
    DataLineage,
    ConsentRecord,
    RetentionPolicy,
    PrivacyImpactAssessment
)

__version__ = "1.0.0"
__author__ = "TuskLang Enterprise Team"

__all__ = [
    # Compliance Framework
    "ComplianceFrameworkEngine", "ComplianceRegulation", "ComplianceStatus",
    "ViolationSeverity", "AuditEventType", "ComplianceRule", "ComplianceViolation",
    "AuditEvent", "PIIDataClassification",
    
    # Multi-Tenancy
    "MultiTenantManager", "Tenant", "TenantStatus", "TenantTier", "IsolationLevel",
    "ResourceType", "ResourceQuota", "TenantConfiguration", "TenantProvisioningTask",
    "UsageMetrics",
    
    # Package Management
    "PackageDistributor", "PackageEcosystem", "PackageStatus", "PackageVersion",
    "PackageMetadata", "PackageArtifact", "DistributionTarget",
    
    # Identity Management
    "EnterpriseIdentityManager", "IdentityProvider", "AuthenticationMethod",
    "PermissionLevel", "Role", "User", "Session", "SAMLConfig", "LDAPConfig",
    
    # Data Governance
    "DataGovernanceEngine", "DataClassification", "PrivacyRegulation",
    "DataCategory", "ConsentStatus", "RetentionAction", "DataAsset",
    "DataLineage", "ConsentRecord", "RetentionPolicy", "PrivacyImpactAssessment"
]

# Enterprise features summary
ENTERPRISE_FEATURES = {
    "compliance": {
        "description": "SOC2, HIPAA, GDPR, PCI-DSS compliance automation",
        "regulations_supported": 8,
        "audit_capabilities": True,
        "automated_checking": True
    },
    "multitenancy": {
        "description": "Complete tenant isolation and resource management",
        "isolation_levels": 4,
        "resource_quotas": True,
        "auto_provisioning": True
    },
    "packaging": {
        "description": "Multi-platform package distribution ecosystem",
        "ecosystems_supported": 7,
        "automated_publishing": True,
        "cross_platform": True
    },
    "identity": {
        "description": "Enterprise SSO, SAML, LDAP, MFA authentication",
        "providers_supported": 8,
        "sso_enabled": True,
        "rbac_system": True
    },
    "governance": {
        "description": "Data governance with lineage tracking and privacy controls",
        "privacy_regulations": 6,
        "automated_lineage": True,
        "retention_policies": True
    }
}
