#!/usr/bin/env python3
"""
FUJSEN Engine for TuskLang Python SDK
=====================================
FUll JavaScript ENgine - Advanced function serialization and execution
"""

# Import FUJSEN components
try:
    from .fujsen import Fujsen, FujsenFunction
    from .serialize_function import serialize_function
    from .deserialize_function import deserialize_function
    from .execute_function import execute_function
except ImportError:
    # Fallback if files don't exist
    pass

__all__ = [
    'Fujsen',
    'FujsenFunction',
    'serialize_function',
    'deserialize_function', 
    'execute_function'
] 