# Agent A2 - Monitoring & Observability Mission

## 🎯 **YOUR MISSION**
You are **Agent A2**, responsible for implementing **monitoring and observability operators** that provide visibility into distributed systems. Your work enables tracing, metrics collection, and workflow orchestration.

## 📋 **ASSIGNED OPERATORS**
1. **@jaeger** - Distributed tracing system
2. **@zipkin** - Distributed tracing aggregation
3. **@grafana** - Dashboard and visualization
4. **@temporal** - Workflow orchestration

## 🚀 **SUCCESS CRITERIA**
- [ ] All 4 operators fully functional with **NO PLACEHOLDER CODE**
- [ ] Each operator 350-500 lines of production-quality Go code
- [ ] Real tracing, metrics, and workflow capabilities
- [ ] Complete test suites with integration tests
- [ ] Working examples demonstrating monitoring scenarios
- [ ] Follow existing SDK patterns and architecture

## 📁 **FILE STRUCTURE**
```
sdk/go/src/operators/
├── monitoring/jaeger.go
├── monitoring/zipkin.go
├── monitoring/grafana.go
└── workflow/temporal.go
```

## 🔧 **IMPLEMENTATION REQUIREMENTS**

### **Pattern to Follow:**
Study existing operators like `src/operators/monitoring/prometheus.go` (289 lines) for monitoring patterns and `src/operators/communication/websocket.go` (305 lines) for real-time capabilities.

### **Monitoring Operators Must Have:**
1. **Trace/Span Management** - Create, collect, and analyze traces
2. **Metrics Collection** - Gather and process performance metrics
3. **Dashboard Integration** - Create and manage visualizations
4. **Alert Management** - Configure and trigger alerts
5. **Real-time Processing** - Handle streaming data efficiently

### **Example Jaeger Structure:**
```go
type JaegerOperator struct {
    tracer    opentracing.Tracer
    reporter  jaeger.Reporter
    config    JaegerConfig
    mutex     sync.RWMutex
}

func NewJaegerOperator(serviceName string, endpoint string) (*JaegerOperator, error) {
    // Real Jaeger tracer initialization
}

func (j *JaegerOperator) CreateSpan(operationName string) opentracing.Span {
    // Real span creation with context
}
```

### **Temporal Workflow Structure:**
```go
type TemporalOperator struct {
    client   client.Client
    worker   worker.Worker
    config   TemporalConfig
    mutex    sync.RWMutex
}

func (t *TemporalOperator) ExecuteWorkflow(workflowType string, input interface{}) error {
    // Real workflow execution
}
```

## ⚠️ **CRITICAL CONSTRAINTS**
- **NO CONFLICTS:** Only modify files assigned to you
- **PRODUCTION QUALITY:** Match existing SDK standards
- **REAL MONITORING:** Actual trace collection and metrics
- **CONCURRENT SAFE:** All operations must be thread-safe
- **PERFORMANCE:** Minimal overhead on monitored systems

## 🎯 **DELIVERABLES**
1. **4 Operator Files** - Complete monitoring implementations
2. **4 Test Files** - Comprehensive test suites with mock services
3. **4 Example Files** - Working monitoring demonstrations
4. **Updated goals.json** - Mark completed goals as true

## 🚦 **START COMMAND**
```bash
cd /opt/tsk_git/reference/todo-july21/a2
# Begin with Jaeger operator - distributed tracing foundation
# Study existing prometheus.go for monitoring patterns
```

**Remember: You are building the eyes and ears of the distributed system. Accuracy and performance monitoring are crucial!** 👁️ 