"""
TuskLang Python SDK - Multi-Platform Integration Package
Enables TuskLang to run across 8 major development platforms
"""

# Platform integrations
from .wasm import WebAssemblyIntegration
from .nodejs import NodeJSIntegration
from .browser import BrowserExtensionIntegration
from .unity import UnityIntegration
from .azure import AzureFunctionsIntegration
from .rails import RailsIntegration
from .jekyll import JekyllIntegration
from .kubernetes import KubernetesIntegration

__all__ = [
    # WebAssembly Platform
    'WebAssemblyIntegration',
    
    # Node.js Platform
    'NodeJSIntegration',
    
    # Browser Extension Platform
    'BrowserExtensionIntegration',
    
    # Unity Game Engine Platform
    'UnityIntegration',
    
    # Azure Functions Platform
    'AzureFunctionsIntegration',
    
    # Ruby on Rails Platform
    'RailsIntegration',
    
    # Jekyll Static Site Generator Platform
    'JekyllIntegration',
    
    # Kubernetes Platform
    'KubernetesIntegration'
]

__version__ = "1.0.0"
__platforms__ = [
    "WebAssembly", "Node.js", "Browser Extension", "Unity", 
    "Azure Functions", "Ruby on Rails", "Jekyll", "Kubernetes"
] 