"""
TuskLang Python SDK - Browser Extension Platform Integration
Enables TuskLang to run as browser extensions with Manifest v3 compatibility
"""

from .browser_integration import BrowserExtensionIntegration
from .content_scripts import ContentScriptManager
from .background_scripts import BackgroundScriptManager
from .storage_manager import ExtensionStorageManager

__all__ = [
    'BrowserExtensionIntegration',
    'ContentScriptManager',
    'BackgroundScriptManager',
    'ExtensionStorageManager'
]

__version__ = "1.0.0"
__platform__ = "Browser Extension" 