"""
TuskLang Python SDK - Kubernetes Platform Integration
Enables TuskLang to run as Kubernetes operators with CRDs and controllers
"""

from .kubernetes_integration import KubernetesIntegration
from .operator_controller import OperatorController
from .custom_resources import CustomResourceManager
from .helm_chart import HelmChartManager

__all__ = [
    'KubernetesIntegration',
    'OperatorController',
    'CustomResourceManager',
    'HelmChartManager'
]

__version__ = "1.0.0"
__platform__ = "Kubernetes" 