"""
TuskLang Python SDK - WebAssembly Platform Integration
Enables TuskLang to run in browser and server-side WebAssembly environments
"""

from .wasm_integration import WebAssemblyIntegration
from .pyodide_adapter import PyodideAdapter
from .browser_bindings import BrowserBindings
from .wasm_optimizer import WasmOptimizer

__all__ = [
    'WebAssemblyIntegration',
    'PyodideAdapter', 
    'BrowserBindings',
    'WasmOptimizer'
]

__version__ = "1.0.0"
__platform__ = "WebAssembly" 