# pylint: disable=too-many-lines
COMPILED_ACCOUNT_CONTRACT = r"""
{
    "abi": [
        {
            "members": [
                {
                    "name": "to",
                    "offset": 0,
                    "type": "felt"
                },
                {
                    "name": "selector",
                    "offset": 1,
                    "type": "felt"
                },
                {
                    "name": "data_offset",
                    "offset": 2,
                    "type": "felt"
                },
                {
                    "name": "data_len",
                    "offset": 3,
                    "type": "felt"
                }
            ],
            "name": "AccountCallArray",
            "size": 4,
            "type": "struct"
        },
        {
            "inputs": [
                {
                    "name": "hash",
                    "type": "felt"
                },
                {
                    "name": "signature_len",
                    "type": "felt"
                },
                {
                    "name": "signature",
                    "type": "felt*"
                }
            ],
            "name": "Account_is_valid_signature",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_public_key",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_nonce",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "interfaceId",
                    "type": "felt"
                }
            ],
            "name": "supportsInterface",
            "outputs": [
                {
                    "name": "success",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "new_public_key",
                    "type": "felt"
                }
            ],
            "name": "set_public_key",
            "outputs": [],
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "public_key",
                    "type": "felt"
                }
            ],
            "name": "constructor",
            "outputs": [],
            "type": "constructor"
        },
        {
            "inputs": [
                {
                    "name": "hash",
                    "type": "felt"
                },
                {
                    "name": "signature_len",
                    "type": "felt"
                },
                {
                    "name": "signature",
                    "type": "felt*"
                }
            ],
            "name": "is_valid_signature",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "call_array_len",
                    "type": "felt"
                },
                {
                    "name": "call_array",
                    "type": "AccountCallArray*"
                },
                {
                    "name": "calldata_len",
                    "type": "felt"
                },
                {
                    "name": "calldata",
                    "type": "felt*"
                },
                {
                    "name": "nonce",
                    "type": "felt"
                }
            ],
            "name": "__execute__",
            "outputs": [
                {
                    "name": "response_len",
                    "type": "felt"
                },
                {
                    "name": "response",
                    "type": "felt*"
                }
            ],
            "type": "function"
        }
    ],
    "entry_points_by_type": {
        "CONSTRUCTOR": [
            {
                "offset": "0x31d",
                "selector": "0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194"
            }
        ],
        "EXTERNAL": [
            {
                "offset": "0x377",
                "selector": "0x15d40a3d6ca2ac30f4031e42be28da9b056fef9bb7357ac5e85627ee876e5ad"
            },
            {
                "offset": "0x2aa",
                "selector": "0x1a35984e05126dbecb7c3bb9929e7dd9106d460c59b1633739a5c733a5fb13b"
            },
            {
                "offset": "0x2c9",
                "selector": "0x1ac47721ee58ba2813c2a816bca188512839a00d3970f67c05eab986b14006d"
            },
            {
                "offset": "0x33a",
                "selector": "0x28420862938116cb3bbdbedee07451ccc54d4e9412dbef71142ad1980a30941"
            },
            {
                "offset": "0x2e9",
                "selector": "0x29e211664c0b63c79638fbea474206ca74016b3e9a3dc4f9ac300ffd8bdf2cd"
            },
            {
                "offset": "0x191",
                "selector": "0x2b793e4b34b47a789f23ea3a1b8c8d91d6279ded93cad8bf25300bbb1cab095"
            },
            {
                "offset": "0x303",
                "selector": "0x2e3e21ff5952b2531241e37999d9c4c8b3034cccc89a202a6bf019bdf5294f9"
            }
        ],
        "L1_HANDLER": []
    },
    "program": {
        "attributes": [],
        "builtins": [
            "pedersen",
            "range_check",
            "ecdsa"
        ],
        "data": [
            "0x40780017fff7fff",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x400380007ffb7ffc",
            "0x400380017ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x480280027ffb8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffd",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480080007fff8000",
            "0x400080007ffd7fff",
            "0x482480017ffd8001",
            "0x1",
            "0x482480017ffd8001",
            "0x1",
            "0xa0680017fff7ffe",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffb",
            "0x402a7ffc7ffd7fff",
            "0x208b7fff7fff7ffe",
            "0x48297ffd80007ffc",
            "0x20680017fff7fff",
            "0x4",
            "0x402780017ffc7ffc",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x3ffffffffffffffffffffffffffffff",
            "0x480280017ffc8000",
            "0x48307fff80007ffe",
            "0x400280027ffc7fff",
            "0x480280017ffc8000",
            "0x484480017fff8000",
            "0x100000000000000000000000000000000",
            "0x480280007ffc8000",
            "0x40317fff7ffe7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x20680017fff7fff",
            "0x10",
            "0x480a7ffc7fff8000",
            "0x482680017ffd8000",
            "0x11000000000000000000000000000000000000000000000101",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480680017fff8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x48127ffe7fff8000",
            "0x48287ffd80007ffe",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe7",
            "0x482680017ffd8000",
            "0x11000000000000000000000000000000000000000000000101",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x20680017fff7fff",
            "0xc",
            "0x40780017fff7fff",
            "0xa",
            "0x480680017fff8000",
            "0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeff",
            "0x480a7ffc7fff8000",
            "0x48287ffd80007ffe",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x10780017fff7fff",
            "0x8",
            "0x40780017fff7fff",
            "0xb",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x43616c6c436f6e7472616374",
            "0x400280007ff97fff",
            "0x400380017ff97ffa",
            "0x400380027ff97ffb",
            "0x400380037ff97ffc",
            "0x400380047ff97ffd",
            "0x482680017ff98000",
            "0x7",
            "0x480280057ff98000",
            "0x480280067ff98000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x47657443616c6c657241646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x476574436f6e747261637441646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f7261676552656164",
            "0x400280007ffc7fff",
            "0x400380017ffc7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x480280027ffc8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f726167655772697465",
            "0x400280007ffb7fff",
            "0x400380017ffb7ffc",
            "0x400380027ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x4765745478496e666f",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x208b7fff7fff7ffe",
            "0x400380017ff97ffa",
            "0x400380007ff97ffb",
            "0x482680017ff98000",
            "0x2",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff9",
            "0x400780017fff8000",
            "0x0",
            "0x400780017fff8001",
            "0x0",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffc",
            "0x5",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x482680017ffc8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x40337fff7ffb8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x48317ffd80008000",
            "0x400080007ffd7ffe",
            "0x480080007ffc8000",
            "0x400080017ffc7fff",
            "0x482480017ffb8000",
            "0x1",
            "0x482480017ffb8000",
            "0x3",
            "0x480080027ffa8000",
            "0x20680017fff7ffb",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff8",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480280007ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x40137ffd7fff8000",
            "0x480280017ffb8000",
            "0x40297ffd7fff8001",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffb7fff8000",
            "0x480280007ffc8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff42",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc1",
            "0x40137ffd7fff8000",
            "0x480280017ffc8000",
            "0x402580017fff8001",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff34",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480680017fff8000",
            "0x10f6bdc8f69644775581b157f06334cb94ae302da4f6d09656c9a31f092cff6",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff2d",
            "0x480a7ffc7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff51",
            "0x48127fe17fff8000",
            "0x48127ffd7fff8000",
            "0x48127ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff0",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff86",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe2",
            "0x480a7ff97fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff7f",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffe00365a",
            "0x20680017fff7fff",
            "0x8",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480680017fff8000",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x208b7fff7fff7ffe",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0xffffffff",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff09",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1813aac5f5e7799684c6dc33e51f44d3627fd748c800724a184ed5be09b713e",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff48",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff42",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1379ac0624b939ceb9dede92211d7db5ee174fe28be72245b0a1a2abd81c98f",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff2a",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff24",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff0f",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff05",
            "0x40127fff7fff7ff9",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffdc",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffb8",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffeb",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffda",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd3",
            "0x480680017fff8000",
            "0xf10dbd44",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff91",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffbc",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x48127ffd7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffefc",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280017ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x48307fff7ffe8000",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x482680017ffd8000",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffde",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x10",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffed4",
            "0x40137ffe7fff8000",
            "0x480a7ff57fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffec9",
            "0x40137fff7fff8001",
            "0x48127ffe7fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff66",
            "0x40137fff7fff8002",
            "0x40137ffd7fff8003",
            "0x40137ffe7fff8004",
            "0x400b7ffd7fff8002",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe40",
            "0x40137fff7fff8005",
            "0x48127ff97fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a80057fff8000",
            "0x1104800180018000",
            "0xba",
            "0x4003800180018006",
            "0x400b7ff97fff8007",
            "0x400b80057fff8008",
            "0x400b80027fff8009",
            "0x400380028001800a",
            "0x400380008001800b",
            "0x480a80037fff8000",
            "0x4826800180008000",
            "0x6",
            "0x1104800180018000",
            "0x47",
            "0x48127ffd7fff8000",
            "0x48127ffd7fff8000",
            "0x480a80047fff8000",
            "0x480a7ff87fff8000",
            "0x48127ffb7fff8000",
            "0x4802800380018000",
            "0x4802800480018000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffa4",
            "0x40137fff7fff800c",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x4826800180028000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff49",
            "0x40137ffe7fff800d",
            "0x40137fff7fff800e",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe18",
            "0x40137fff7fff800f",
            "0x48127ffa7fff8000",
            "0x480a80077fff8000",
            "0x480a80087fff8000",
            "0x480a800f7fff8000",
            "0x1104800180018000",
            "0x9",
            "0x48127ffe7fff8000",
            "0x480a800d7fff8000",
            "0x480a800e7fff8000",
            "0x480a800c7fff8000",
            "0x48127ffb7fff8000",
            "0x480a800f7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x20780017fff7ffb",
            "0x6",
            "0x480a7ffa7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480280007ffc8000",
            "0x480280017ffc8000",
            "0x480280027ffc8000",
            "0x480280037ffc8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe4e",
            "0x40137ffe7fff8000",
            "0x40137fff7fff8001",
            "0x40137ffd7fff8002",
            "0x480a7ffd7fff8000",
            "0x480a80017fff8000",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffdfc",
            "0x480a80027fff8000",
            "0x482680017ffb8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffc8000",
            "0x4",
            "0x482a80007ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe4",
            "0x48127ffe7fff8000",
            "0x482880007ffe8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x0",
            "0x480a7ffc7fff8000",
            "0x480280017ffd8000",
            "0x480280027ffd8000",
            "0x1104800180018000",
            "0x1f",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe69",
            "0x48127ff77fff8000",
            "0x48127ffe7fff8000",
            "0x480680017fff8000",
            "0x537461726b4e6574205472616e73616374696f6e",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe96",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe93",
            "0x48127fd47fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe90",
            "0x480280037ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe8d",
            "0x480280047ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe8a",
            "0x480280057ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe87",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe95",
            "0x480a7ffb7fff8000",
            "0x48127ffd7fff8000",
            "0x48127ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffdc0",
            "0x40137fff7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0xd",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe41",
            "0x48127ff87fff8000",
            "0x48127ffe7fff8000",
            "0x480a80007fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe5e",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe7c",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffb",
            "0x4",
            "0x480a7ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480280027ffc8000",
            "0x480280037ffc8000",
            "0x1104800180018000",
            "0x1c",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe2d",
            "0x48127ff77fff8000",
            "0x48127ffe7fff8000",
            "0x480280007ffc8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe5b",
            "0x480280017ffc8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe58",
            "0x48127fd47fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe55",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe63",
            "0x400280007ffd7fff",
            "0x48127ffe7fff8000",
            "0x482680017ffb8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffc8000",
            "0x4",
            "0x482680017ffd8000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe1",
            "0x208b7fff7fff7ffe",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe13",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe30",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe4e",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffa",
            "0x4",
            "0x480a7ff97fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280007ffb8000",
            "0x400280007ffd7fff",
            "0x480280017ffb8000",
            "0x400280017ffd7fff",
            "0x480280037ffb8000",
            "0x400280027ffd7fff",
            "0x480280027ffb8000",
            "0x48327fff7ffc8000",
            "0x400280037ffd7fff",
            "0x480a7ff97fff8000",
            "0x482680017ffa8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffb8000",
            "0x4",
            "0x480a7ffc7fff8000",
            "0x482680017ffd8000",
            "0x4",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffec",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffec3",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeaa",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe20",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffea",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe6d",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe5c",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe4a",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280017ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x48307fff7ffe8000",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x482680017ffd8000",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe5",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff57fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe4f",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x4003800080007ffb",
            "0x400380007ffd7ffb",
            "0x402780017ffd8001",
            "0x1",
            "0x4826800180008000",
            "0x1",
            "0x40297ffb7fff8002",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffc7fff8000",
            "0x480a7ffb7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffc99",
            "0x480a80017fff8000",
            "0x4829800080008002",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x1",
            "0x480280007ffd8000",
            "0x484480017fff8000",
            "0x4",
            "0x48307fff7ffd8000",
            "0x480280027ffb8000",
            "0x480080007ffe8000",
            "0x400080017ffe7fff",
            "0x482480017ffd8000",
            "0x1",
            "0x480080007ffc8000",
            "0x48307fff7ffe8000",
            "0x482480017fff8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x2",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x482680017ffd8000",
            "0x1",
            "0x480080007ff28000",
            "0x482480017ff18000",
            "0x1",
            "0x480080007ff58000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc0",
            "0x40137ffa7fff8000",
            "0x40137ffb7fff8001",
            "0x40137ffd7fff8002",
            "0x48127ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc6",
            "0x480a80007fff8000",
            "0x480a80017fff8000",
            "0x48127ffb7fff8000",
            "0x480a80027fff8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe"
        ],
        "debug_info": {
            "file_contents": {
                "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo": "assert [cast(fp + (-4), felt*)] = __calldata_actual_size\n",
                "autogen/starknet/arg_processor/1e2484a22faa61a56a85fee309cc4bac0c6f9bbbdc4428579cdc70d444fc4ff7.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = ret_struct.response_len\n# Store the updated range_check_ptr as a local variable to keep it available after\n# the memcpy.\nlocal range_check_ptr = range_check_ptr + 1\n# Keep a reference to __return_value_ptr.\nlet __return_value_ptr_copy = __return_value_ptr\n# Store the updated __return_value_ptr as a local variable to keep it available after\n# the memcpy.\nlocal __return_value_ptr : felt* = __return_value_ptr + ret_struct.response_len * 1\nmemcpy(\n    dst=__return_value_ptr_copy,\n    src=ret_struct.response,\n    len=ret_struct.response_len * 1)\n",
                "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo": "let __calldata_arg_call_array_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/2af83e2ace09380d3be2e1d366c8649a74753b790c9d2b5e425bfdf350d70145.cairo": "let __calldata_arg_nonce = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/4f07c4ae795d22b6bc4426e596637ee88f870711dc3768dd8178092f4b2c0b65.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_calldata_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_calldata = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_calldata_len * 1\n",
                "autogen/starknet/arg_processor/5d2294ce8e305b1bd560f56804793340439bb863103e1ba5c235e3d08cf6d272.cairo": "let __calldata_arg_interfaceId = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo": "let __calldata_actual_size =  __calldata_ptr - cast([cast(fp + (-3), felt**)], felt*)\n",
                "autogen/starknet/arg_processor/7af4bd4fbb5dd50674824547868ce179672433087ba629fa3b41cfc375f33be5.cairo": "assert [__return_value_ptr] = ret_struct.success\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_call_array_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_call_array = cast(__calldata_ptr, openzeppelin.account.library.AccountCallArray*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_call_array_len * 4\n",
                "autogen/starknet/arg_processor/8799496fe2567340f6719cfd30d7db5f6b8e7aa420ca97e3a3c3ccbdfbb2e674.cairo": "let __calldata_arg_calldata_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/8f57d6d152b155403dcead27a17163e42b24753da9c724f554705dcf260464c0.cairo": "assert [__return_value_ptr] = ret_struct.response_len\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo": "let __calldata_arg_new_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_signature_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_signature = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_signature_len * 1\n",
                "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo": "let __calldata_arg_signature_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo": "let __calldata_arg_hash = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f68ac5127c2e5f488e054b6e5406fbd4412fe40038204608d22aadbaf91f8427.cairo": "let __calldata_arg_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo": "assert [__return_value_ptr] = ret_struct.res\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/external/Account_is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/Account_is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(hash=__calldata_arg_hash, signature_len=__calldata_arg_signature_len, signature=__calldata_arg_signature,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/Account_is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/Account_is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/__execute__/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/__execute__/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/__execute__/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/__execute__/c5ef3c66f2d3401b698389ddc9299fbbd37ff02241413d87bef344301e990c4d.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(call_array_len=__calldata_arg_call_array_len, call_array=__calldata_arg_call_array, calldata_len=__calldata_arg_calldata_len, calldata=__calldata_arg_calldata, nonce=__calldata_arg_nonce,)\nlet (range_check_ptr, retdata_size, retdata) = __execute___encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/__execute__/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/__execute__/e2645b5103a9d5af449b8fe7ba025f8f981a7d85f0d6bd668f32b9064d8689dd.cairo": "func __execute__() -> (syscall_ptr : felt*, pedersen_ptr : starkware.cairo.common.cairo_builtins.HashBuiltin*, range_check_ptr : felt, ecdsa_ptr : starkware.cairo.common.cairo_builtins.SignatureBuiltin*, size, retdata : felt*):\n    alloc_locals\nend\n",
                "autogen/starknet/external/__execute__/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/constructor/0436d9c54f27d04f955450289b3e58687541637e8518c4e0b75af1f455ca5246.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(public_key=__calldata_arg_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/constructor/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/constructor/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/constructor/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/constructor/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_nonce/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_nonce/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_nonce_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_nonce/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_nonce/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_public_key_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(hash=__calldata_arg_hash, signature_len=__calldata_arg_signature_len, signature=__calldata_arg_signature,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/return/__execute__/f31bd541c80bf9ec5afbbad795fa002730b10621ee3f52b2e7956c06cd223d2e.cairo": "func __execute___encode_return(ret_struct : __main__.__execute__.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo": "func get_nonce_encode_return(ret_struct : __main__.get_nonce.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo": "func get_public_key_encode_return(ret_struct : __main__.get_public_key.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/supportsInterface/037a3fe20b5598fee7bfabbca23354a68e9dd74b234d25d6640003a291b56483.cairo": "func supportsInterface_encode_return(ret_struct : __main__.supportsInterface.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/set_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/set_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(new_public_key=__calldata_arg_new_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/set_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/set_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/supportsInterface/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/supportsInterface/3bbfa76e3ba08d2de75ecebf03a71a4c601c1fed5524a7a8db9ff7c36edb527d.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(interfaceId=__calldata_arg_interfaceId,)\nlet (range_check_ptr, retdata_size, retdata) = supportsInterface_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/supportsInterface/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/supportsInterface/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/supportsInterface/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/storage_var/Account_current_nonce/decl.cairo": "namespace Account_current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/Account_current_nonce/impl.cairo": "namespace Account_current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 680641068382147823690491849560675892800103278811133310055689865859989991742\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/Account_public_key/decl.cairo": "namespace Account_public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/Account_public_key/impl.cairo": "namespace Account_public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 550557492744938365112574611882025123252567779123164597803728068558738016655\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo": "namespace ERC165_supported_interfaces:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}(interface_id : felt) -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n            interface_id : felt) -> (is_supported : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n            interface_id : felt, value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo": "namespace ERC165_supported_interfaces:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}(interface_id : felt) -> (res : felt):\n        let res = 479559987705328862372362947504386080106579713470203672197513890426980061174\n        let (res) = hash2{hash_ptr=pedersen_ptr}(res, cast(&interface_id, felt*)[0])\n        let (res) = normalize_address(addr=res)\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n            interface_id : felt) -> (is_supported : felt):\n        let (storage_addr) = addr(interface_id)\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n            interface_id : felt, value : felt):\n        let (storage_addr) = addr(interface_id)\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend"
            },
            "instruction_locations": {
                "0": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/alloc.cairo"
                                },
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 12,
                        "end_line": 4,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "2": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 1
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 5,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 5
                    }
                },
                "3": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "4": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 15,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 15
                    }
                },
                "5": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 18
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 17
                    }
                },
                "7": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "start_col": 20,
                                "start_line": 18
                            },
                            "While expanding the reference 'result' in:"
                        ],
                        "start_col": 18,
                        "start_line": 16
                    }
                },
                "8": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 18
                    }
                },
                "9": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 8,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 8
                    }
                },
                "11": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 9,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "12": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 41,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 12
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 35,
                                "start_line": 13
                            },
                            "While expanding the reference 'dst' in:"
                        ],
                        "start_col": 13,
                        "start_line": 2
                    }
                },
                "13": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 44,
                                "start_line": 13
                            },
                            "While expanding the reference 'src' in:"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "14": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 26,
                        "start_line": 17
                    }
                },
                "15": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "16": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "18": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 23
                    }
                },
                "20": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 44,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "22": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 31
                    }
                },
                "23": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 26,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 33
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "24": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_not_equal.a": 13,
                            "starkware.cairo.common.math.assert_not_equal.b": 14
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 29,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 5,
                                "start_line": 20
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 8,
                        "start_line": 30
                    }
                },
                "25": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_not_equal.__temp1": 15,
                            "starkware.cairo.common.math.assert_not_equal.a": 13,
                            "starkware.cairo.common.math.assert_not_equal.b": 14
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 30
                    }
                },
                "27": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_not_equal.__temp1": 15,
                            "starkware.cairo.common.math.assert_not_equal.a": 13,
                            "starkware.cairo.common.math.assert_not_equal.b": 14
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 9,
                        "start_line": 32
                    }
                },
                "29": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_not_equal.__temp1": 15,
                            "starkware.cairo.common.math.assert_not_equal.a": 13,
                            "starkware.cairo.common.math.assert_not_equal.b": 14
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 35,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 35
                    }
                },
                "30": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 5,
                                "start_line": 89
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 50,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 36,
                        "start_line": 100
                    }
                },
                "32": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 57,
                                "end_line": 100,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 53,
                                "start_line": 100
                            },
                            "While expanding the reference 'high' in:"
                        ],
                        "start_col": 16,
                        "start_line": 87
                    }
                },
                "33": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 36,
                        "start_line": 100
                    }
                },
                "34": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 100
                    }
                },
                "35": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 20,
                                "start_line": 105
                            },
                            "While expanding the reference 'high' in:"
                        ],
                        "start_col": 16,
                        "start_line": 87
                    }
                },
                "36": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.__temp5": 23,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 105,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 20,
                        "start_line": 105
                    }
                },
                "38": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.__temp5": 23,
                            "starkware.cairo.common.math.assert_250_bit.__temp6": 24,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 86,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 35,
                                "start_line": 105
                            },
                            "While expanding the reference 'low' in:"
                        ],
                        "start_col": 15,
                        "start_line": 86
                    }
                },
                "39": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.__temp5": 23,
                            "starkware.cairo.common.math.assert_250_bit.__temp6": 24,
                            "starkware.cairo.common.math.assert_250_bit.__temp7": 25,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 17,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 105,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 105
                    }
                },
                "40": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.__temp5": 23,
                            "starkware.cairo.common.math.assert_250_bit.__temp6": 24,
                            "starkware.cairo.common.math.assert_250_bit.__temp7": 25,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 26,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 107,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 81,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 108,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 108
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 81
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 107
                    }
                },
                "42": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.math.assert_250_bit.__temp2": 20,
                            "starkware.cairo.common.math.assert_250_bit.__temp3": 21,
                            "starkware.cairo.common.math.assert_250_bit.__temp4": 22,
                            "starkware.cairo.common.math.assert_250_bit.__temp5": 23,
                            "starkware.cairo.common.math.assert_250_bit.__temp6": 24,
                            "starkware.cairo.common.math.assert_250_bit.__temp7": 25,
                            "starkware.cairo.common.math.assert_250_bit.high": 19,
                            "starkware.cairo.common.math.assert_250_bit.low": 18,
                            "starkware.cairo.common.math.assert_250_bit.range_check_ptr": 26,
                            "starkware.cairo.common.math.assert_250_bit.value": 16
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 108,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 108
                    }
                },
                "43": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 5,
                        "start_line": 13
                    }
                },
                "45": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 5,
                                "start_line": 14
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 7,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "47": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 81,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 26,
                                        "end_line": 50,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 50
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 81
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "48": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 48,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 50,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 50
                            },
                            "While expanding the reference 'x' in:"
                        ],
                        "start_col": 17,
                        "start_line": 48
                    }
                },
                "50": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 50
                    }
                },
                "52": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 32,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 51
                            },
                            "While expanding the reference 'y' in:"
                        ],
                        "start_col": 18,
                        "start_line": 49
                    }
                },
                "54": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp8": 33,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 32,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 81,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 50,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 81,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 26,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 51
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 81
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 50
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 81
                    }
                },
                "55": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp8": 33,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 32,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 51
                            },
                            "While expanding the reference 'y' in:"
                        ],
                        "start_col": 17,
                        "start_line": 49
                    }
                },
                "56": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 15
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp8": 33,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 32,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 51
                    }
                },
                "58": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 24
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp8": 33,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 34,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 52,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 21,
                        "start_line": 52
                    }
                },
                "60": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 25
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp8": 33,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 34,
                            "starkware.starknet.common.storage.normalize_address.x": 30,
                            "starkware.starknet.common.storage.normalize_address.y": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 52,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 52
                    }
                },
                "61": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 23
                    }
                },
                "63": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 57,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 9,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 11,
                        "end_line": 25,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "65": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 30
                    }
                },
                "67": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 28,
                        "start_line": 32
                    }
                },
                "69": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp9": 36,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 81,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 32,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 32
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 81
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "70": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp9": 36,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 28,
                        "start_line": 32
                    }
                },
                "71": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 15
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp9": 36,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 32
                    }
                },
                "73": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 24
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.__temp9": 36,
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 11,
                        "end_line": 25,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "75": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 26,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 26
                    }
                },
                "77": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 81,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 28,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 28
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 81
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "78": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 28,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 28,
                                "start_line": 28
                            },
                            "While expanding the reference 'addr' in:"
                        ],
                        "start_col": 41,
                        "start_line": 12
                    }
                },
                "79": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 15
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 28
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 28
                    }
                },
                "81": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 24
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 39
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 34,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 21,
                                "start_line": 34
                            },
                            "While expanding the reference 'addr' in:"
                        ],
                        "start_col": 41,
                        "start_line": 12
                    }
                },
                "82": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 25
                        },
                        "reference_ids": {
                            "starkware.starknet.common.storage.normalize_address.addr": 27,
                            "starkware.starknet.common.storage.normalize_address.is_250": 35,
                            "starkware.starknet.common.storage.normalize_address.is_small": 29,
                            "starkware.starknet.common.storage.normalize_address.range_check_ptr": 39
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 34
                    }
                },
                "83": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 47,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 47
                    }
                },
                "85": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "86": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "87": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "88": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "89": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 44
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "90": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.response": 47,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 48
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 52,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 52
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 55,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 42,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 42
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 55
                    }
                },
                "92": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.response": 47,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 26,
                        "start_line": 56
                    }
                },
                "93": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.response": 47,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 57,
                        "start_line": 56
                    }
                },
                "94": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp10": 46,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 43,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 42,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 40,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 41,
                            "starkware.starknet.common.syscalls.call_contract.response": 47,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 45,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 56
                    }
                },
                "95": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 50,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 49
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 90,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 63,
                        "start_line": 114
                    }
                },
                "97": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp11": 51,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 50,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 49
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 91,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 114
                    }
                },
                "98": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp11": 51,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 50,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 52
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 93,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 115
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 58,
                        "end_line": 116,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 117,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 117
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 112
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 116
                    }
                },
                "100": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp11": 51,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 50,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 117,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 28,
                        "start_line": 117
                    }
                },
                "101": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp11": 51,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 50,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 60,
                        "end_line": 117,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 117
                    }
                },
                "102": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 54,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 53
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 188,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 65,
                        "start_line": 188
                    }
                },
                "104": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp12": 55,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 54,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 53
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 188,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 188
                    }
                },
                "105": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp12": 55,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 54,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 56
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 95,
                                "end_line": 189,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 189
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 60,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 191,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 191
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 186
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 190
                    }
                },
                "107": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp12": 55,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 54,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 191,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 30,
                        "start_line": 191
                    }
                },
                "108": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp12": 55,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 54,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 191,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 191
                    }
                },
                "109": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 58,
                        "start_line": 266
                    }
                },
                "111": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp13": 60,
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 266
                    }
                },
                "112": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp13": 60,
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 266
                    }
                },
                "113": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp13": 60,
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.response": 61,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 62
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 87,
                                "end_line": 267,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 267
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 53,
                        "end_line": 269,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 270,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 270
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 269
                    }
                },
                "115": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp13": 60,
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.response": 61,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 62
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 19,
                        "start_line": 270
                    }
                },
                "116": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp13": 60,
                            "starkware.starknet.common.syscalls.storage_read.address": 57,
                            "starkware.starknet.common.syscalls.storage_read.response": 61,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 59,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 62
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 270
                    }
                },
                "117": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 65,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 284
                    }
                },
                "119": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp14": 66,
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 65,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "120": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp14": 66,
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 65,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "121": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp14": 66,
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 65,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "122": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp14": 66,
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 67,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 285,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 285
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 286,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 287,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 287
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 286
                    }
                },
                "124": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp14": 66,
                            "starkware.starknet.common.syscalls.storage_write.address": 63,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 67,
                            "starkware.starknet.common.syscalls.storage_write.value": 64
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 287,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 287
                    }
                },
                "125": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 69,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 68
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 346,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 56,
                        "start_line": 346
                    }
                },
                "127": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp15": 70,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 69,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 68
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 77,
                        "end_line": 346,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 346
                    }
                },
                "128": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp15": 70,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 71,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 69,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 72
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 86,
                                "end_line": 347,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 347
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 51,
                        "end_line": 349,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 344,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 350,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 350
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 344
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 349
                    }
                },
                "130": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp15": 70,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 71,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 69,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 72
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 350,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 21,
                        "start_line": 350
                    }
                },
                "131": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp15": 70,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 71,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 69,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 72
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 350,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 350
                    }
                },
                "132": {
                    "accessible_scopes": [
                        "starkware.cairo.common.registers",
                        "starkware.cairo.common.registers.get_fp_and_pc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 6,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/registers.cairo"
                        },
                        "start_col": 5,
                        "start_line": 6
                    }
                },
                "133": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 77,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 73,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 74,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 75,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 76
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 98,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "start_col": 5,
                                "start_line": 9
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 39,
                        "end_line": 10,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 10
                    }
                },
                "134": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 77,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 73,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 74,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 75,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 11,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 11
                    }
                },
                "135": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 78,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 73,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 74,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 75,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 13
                    }
                },
                "137": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 78,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 73,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 74,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 75,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "138": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "140": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 2
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 18
                    }
                },
                "142": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 79,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 80
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 20,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 20
                    }
                },
                "144": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 79,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 80
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 21
                    }
                },
                "146": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 79,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 80
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 22,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 29,
                                "start_line": 22
                            },
                            "While expanding the reference 'hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 19
                    }
                },
                "147": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 79,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 80
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "148": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "150": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 30,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 30
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 27
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 27
                    }
                },
                "151": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 30,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 22,
                                "start_line": 30
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 47,
                        "start_line": 28
                    }
                },
                "152": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 9,
                        "start_line": 30
                    }
                },
                "153": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 33
                    }
                },
                "155": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 35,
                        "start_line": 34
                    }
                },
                "157": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "158": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 43,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 43
                    }
                },
                "159": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 44,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "160": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 45,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 45
                    }
                },
                "161": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 72,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 36,
                        "start_line": 50
                    }
                },
                "162": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 53,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 53
                    }
                },
                "163": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 54
                    }
                },
                "164": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 54
                    }
                },
                "165": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 91,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 58,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 58
                    }
                },
                "167": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 8
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 91,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 59,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 59
                    }
                },
                "169": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 91,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 60,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 60
                    }
                },
                "170": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 91,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 63,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 63
                    }
                },
                "172": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp16": 85,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp17": 90,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 86,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 82,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 81,
                            "starkware.cairo.common.hash_state.hash_update_inner.final_locals": 92,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 87,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 83,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 93,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 89,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 91,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 68,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 68
                    }
                },
                "173": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 76,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 76
                    }
                },
                "175": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 73,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 86,
                                        "end_line": 78,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 77
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 27
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 73
                    }
                },
                "176": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 74,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 18,
                                "start_line": 78
                            },
                            "While expanding the reference 'data_ptr' in:"
                        ],
                        "start_col": 38,
                        "start_line": 74
                    }
                },
                "177": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 74,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 51,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 40,
                                "start_line": 78
                            },
                            "While expanding the reference 'data_length' in:"
                        ],
                        "start_col": 56,
                        "start_line": 74
                    }
                },
                "178": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 78,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 58,
                        "start_line": 78
                    }
                },
                "179": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 97,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 78,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 77
                    }
                },
                "181": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 79,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 79
                    }
                },
                "183": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 81,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 81
                    }
                },
                "184": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 82
                    }
                },
                "185": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.__temp18": 102,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 82
                    }
                },
                "186": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.__temp18": 102,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 73,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 83
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 18,
                                        "start_line": 73
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 77
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 27
                    }
                },
                "187": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.__temp18": 102,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 80,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 83
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 80
                    }
                },
                "188": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 100,
                            "starkware.cairo.common.hash_state.hash_update.__temp18": 102,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 96,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 95,
                            "starkware.cairo.common.hash_state.hash_update.hash": 99,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 98,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 94,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 83,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 83
                    }
                },
                "189": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 105,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 89,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 89
                    }
                },
                "191": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 105,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 90,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 90
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 87
                    }
                },
                "192": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 105,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 26,
                        "start_line": 90
                    }
                },
                "193": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 105,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 61,
                                "end_line": 90,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 57,
                                "start_line": 90
                            },
                            "While expanding the reference 'item' in:"
                        ],
                        "start_col": 79,
                        "start_line": 87
                    }
                },
                "194": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 105,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 62,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 90
                    }
                },
                "196": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 91,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 91
                    }
                },
                "198": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 93
                    }
                },
                "199": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 94,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 94
                    }
                },
                "200": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp19": 110,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 94,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 94
                    }
                },
                "202": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp19": 110,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 62,
                                "end_line": 90,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 87,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 95,
                                                "input_file": {
                                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 95
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 87
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 90
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 12,
                        "start_line": 13
                    }
                },
                "203": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp19": 110,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 92,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 95,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 95
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 92
                    }
                },
                "204": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 108,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp19": 110,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 107,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 106,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 103,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 104,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 109
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 95
                    }
                },
                "205": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 112,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 99,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 100,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 12,
                                        "start_line": 100
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 99
                    }
                },
                "206": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 112,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 20,
                        "start_line": 100
                    }
                },
                "207": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 112,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 51,
                        "start_line": 100
                    }
                },
                "208": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 112,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 12,
                        "start_line": 100
                    }
                },
                "210": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 113,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 100
                    }
                },
                "211": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 115,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 117
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 36,
                                "start_line": 9
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "212": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 115,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 117
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 53,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 50,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "214": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 115,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 117
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 84,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 9
                    }
                },
                "215": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 115,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 117
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 21,
                        "start_line": 9
                    }
                },
                "217": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 119
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 10
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 12
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "218": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 119
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 10,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 44,
                                "start_line": 10
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 14,
                        "start_line": 9
                    }
                },
                "219": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 116,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 119
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 21,
                        "start_line": 10
                    }
                },
                "221": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 36
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 120,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 11
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 9
                    }
                },
                "222": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 37
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 120,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 10,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 7,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 11,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 11
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 7
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 10
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "223": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 38
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 120,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 11,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 11
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 14,
                        "start_line": 10
                    }
                },
                "224": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 39
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.interface_id": 114,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.pedersen_ptr": 118,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.range_check_ptr": 120,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr.res": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 11
                    }
                },
                "225": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 124,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 125,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 16
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 14
                    }
                },
                "226": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 124,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 125,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 16
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 14
                    }
                },
                "227": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 124,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 125,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 15,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 16,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 35,
                                "start_line": 16
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 13,
                        "start_line": 15
                    }
                },
                "228": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 124,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 125,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 16,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 16
                    }
                },
                "230": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 44
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 126,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 17
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 14
                    }
                },
                "231": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 45
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 126,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 16,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 17
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 16
                    }
                },
                "232": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 46
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 126,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 123
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 17,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 17
                    }
                },
                "234": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 51
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.__storage_var_temp0": 130,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 126,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 129
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 264,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 17
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 264
                    }
                },
                "235": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 52
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.__storage_var_temp0": 130,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 126,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 131
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 16,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 20,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 20
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 16
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "236": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 53
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.__storage_var_temp0": 130,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 132,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 127,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 131
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 16,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 21,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 21
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 16
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "237": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 54
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.__storage_var_temp0": 130,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 132,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 133,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 131
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 17,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 22,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 22
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 17
                    }
                },
                "238": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 55
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.__storage_var_temp0": 134,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.interface_id": 122,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.pedersen_ptr": 132,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.range_check_ptr": 133,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.storage_addr": 128,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read.syscall_ptr": 131
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 23
                    }
                },
                "239": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 138,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 139,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 28,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 28
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 26
                    }
                },
                "240": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 138,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 139,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 28,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 28
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 26
                    }
                },
                "241": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 138,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 139,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 27,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 28,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 35,
                                "start_line": 28
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 13,
                        "start_line": 27
                    }
                },
                "242": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 138,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 139,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 28,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 28
                    }
                },
                "244": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 44
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 29,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 29
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 26
                    }
                },
                "245": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 45
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 28,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 29,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 29
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 28
                    }
                },
                "246": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 46
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 29,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 29
                    }
                },
                "247": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 137,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 29,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 29
                    }
                },
                "249": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 51
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 143,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 28,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 20,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 30,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 30
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 20
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 28
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "250": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 52
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 143,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 28,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 20,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 30,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 30
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 20
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 28
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "251": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 53
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.interface_id": 135,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.pedersen_ptr": 140,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.range_check_ptr": 141,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.storage_addr": 142,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.syscall_ptr": 143,
                            "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write.value": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 30,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 30
                    }
                },
                "252": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 8,
                        "start_line": 21
                    }
                },
                "254": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 5,
                        "start_line": 21
                    }
                },
                "256": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 16,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 16
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 16
                    }
                },
                "257": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 17
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 17
                    }
                },
                "258": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 18
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 18
                    }
                },
                "259": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 4
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 17,
                        "start_line": 22
                    }
                },
                "261": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 5
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 9,
                        "start_line": 22
                    }
                },
                "262": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 26,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 26,
                                        "start_line": 26
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 16
                    }
                },
                "263": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 26,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 26,
                                        "start_line": 26
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 17
                    }
                },
                "264": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 26,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 26,
                                        "start_line": 26
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 18
                    }
                },
                "265": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 4
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 71,
                                "end_line": 26,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 59,
                                "start_line": 26
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 8,
                        "start_line": 19
                    }
                },
                "266": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 5
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 146,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 147,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 72,
                        "end_line": 26,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 26,
                        "start_line": 26
                    }
                },
                "268": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supports_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 62
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.__temp20": 148,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.interface_id": 144,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.is_supported": 152,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.pedersen_ptr": 150,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.range_check_ptr": 151,
                            "openzeppelin.introspection.ERC165.ERC165_supports_interface.syscall_ptr": 149
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 5,
                        "start_line": 27
                    }
                },
                "269": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 36,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 22,
                                "start_line": 36
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 8,
                        "start_line": 34
                    }
                },
                "270": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 36,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 36,
                        "start_line": 36
                    }
                },
                "272": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 36,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 5,
                        "start_line": 36
                    }
                },
                "274": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 5
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 58,
                                        "end_line": 37,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 37
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 20
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 31
                    }
                },
                "275": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 6
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 58,
                                        "end_line": 37,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 37
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 20
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 32
                    }
                },
                "276": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 58,
                                        "end_line": 37,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 37
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 20
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 33
                    }
                },
                "277": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 51,
                                "end_line": 37,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 39,
                                "start_line": 37
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 8,
                        "start_line": 34
                    }
                },
                "278": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 53,
                        "start_line": 37
                    }
                },
                "280": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 10
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 155,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 156,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 5,
                        "start_line": 37
                    }
                },
                "282": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_register_interface"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 65
                        },
                        "reference_ids": {
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.interface_id": 153,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.pedersen_ptr": 158,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.range_check_ptr": 159,
                            "openzeppelin.introspection.ERC165.ERC165_register_interface.syscall_ptr": 157
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 38,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 5,
                        "start_line": 38
                    }
                },
                "283": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.addr.pedersen_ptr": 160,
                            "openzeppelin.account.library.Account_current_nonce.addr.range_check_ptr": 161,
                            "openzeppelin.account.library.Account_current_nonce.addr.res": 162
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "284": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.addr.pedersen_ptr": 160,
                            "openzeppelin.account.library.Account_current_nonce.addr.range_check_ptr": 161,
                            "openzeppelin.account.library.Account_current_nonce.addr.res": 162
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "285": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.addr.pedersen_ptr": 160,
                            "openzeppelin.account.library.Account_current_nonce.addr.range_check_ptr": 161,
                            "openzeppelin.account.library.Account_current_nonce.addr.res": 162
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "287": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.addr.pedersen_ptr": 160,
                            "openzeppelin.account.library.Account_current_nonce.addr.range_check_ptr": 161,
                            "openzeppelin.account.library.Account_current_nonce.addr.res": 162
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "288": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 164,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 165,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "289": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 164,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 165,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "290": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 164,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 165,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "292": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 166,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "293": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 166,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "294": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 166,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 163
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "296": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 14
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.__storage_var_temp0": 170,
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 166,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 169
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 264,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 264
                    }
                },
                "297": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 15
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.__storage_var_temp0": 170,
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 166,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 171
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "298": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.__storage_var_temp0": 170,
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 172,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 167,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 171
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "299": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 17
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.__storage_var_temp0": 170,
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 172,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 173,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 171
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "300": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 18
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.read.__storage_var_temp0": 174,
                            "openzeppelin.account.library.Account_current_nonce.read.pedersen_ptr": 172,
                            "openzeppelin.account.library.Account_current_nonce.read.range_check_ptr": 173,
                            "openzeppelin.account.library.Account_current_nonce.read.storage_addr": 168,
                            "openzeppelin.account.library.Account_current_nonce.read.syscall_ptr": 171
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "301": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 177,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 178,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "302": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 177,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 178,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "303": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 177,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 178,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "305": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "306": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "307": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "308": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 10
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 176,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "310": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 14
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 182,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "311": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 15
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 182,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "312": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_current_nonce.write.pedersen_ptr": 179,
                            "openzeppelin.account.library.Account_current_nonce.write.range_check_ptr": 180,
                            "openzeppelin.account.library.Account_current_nonce.write.storage_addr": 181,
                            "openzeppelin.account.library.Account_current_nonce.write.syscall_ptr": 182,
                            "openzeppelin.account.library.Account_current_nonce.write.value": 175
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "313": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.addr.pedersen_ptr": 183,
                            "openzeppelin.account.library.Account_public_key.addr.range_check_ptr": 184,
                            "openzeppelin.account.library.Account_public_key.addr.res": 185
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "314": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.addr.pedersen_ptr": 183,
                            "openzeppelin.account.library.Account_public_key.addr.range_check_ptr": 184,
                            "openzeppelin.account.library.Account_public_key.addr.res": 185
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "315": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.addr.pedersen_ptr": 183,
                            "openzeppelin.account.library.Account_public_key.addr.range_check_ptr": 184,
                            "openzeppelin.account.library.Account_public_key.addr.res": 185
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "317": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.addr.pedersen_ptr": 183,
                            "openzeppelin.account.library.Account_public_key.addr.range_check_ptr": 184,
                            "openzeppelin.account.library.Account_public_key.addr.res": 185
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "318": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 187,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 188,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "319": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 187,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 188,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "320": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 187,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 188,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "322": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 189,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "323": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 189,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "324": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 189,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 186
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "326": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 14
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.__storage_var_temp0": 193,
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 189,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 192
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 264,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 264
                    }
                },
                "327": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 15
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.__storage_var_temp0": 193,
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 189,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 194
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "328": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.__storage_var_temp0": 193,
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 195,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 190,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 194
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "329": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 17
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.__storage_var_temp0": 193,
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 195,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 196,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 194
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "330": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 18
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.read.__storage_var_temp0": 197,
                            "openzeppelin.account.library.Account_public_key.read.pedersen_ptr": 195,
                            "openzeppelin.account.library.Account_public_key.read.range_check_ptr": 196,
                            "openzeppelin.account.library.Account_public_key.read.storage_addr": 191,
                            "openzeppelin.account.library.Account_public_key.read.syscall_ptr": 194
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "331": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 200,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 201,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "332": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 200,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 201,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "333": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 200,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 201,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "335": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "336": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 8
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "337": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 9
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "338": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 10
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 199,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "340": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 14
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 205,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "341": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 15
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 205,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "342": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_public_key.write.pedersen_ptr": 202,
                            "openzeppelin.account.library.Account_public_key.write.range_check_ptr": 203,
                            "openzeppelin.account.library.Account_public_key.write.storage_addr": 204,
                            "openzeppelin.account.library.Account_public_key.write.syscall_ptr": 205,
                            "openzeppelin.account.library.Account_public_key.write.value": 198
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "343": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 206
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 66,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 67,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 67
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 186
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 31,
                        "start_line": 66
                    }
                },
                "344": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 206
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 67,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 18,
                        "start_line": 67
                    }
                },
                "346": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 6
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.self": 208,
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 207
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 67,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 40,
                                                "end_line": 68,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 20,
                                                "start_line": 68
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 112
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 67
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 186
                    }
                },
                "347": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.self": 208,
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 207
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 68,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 20,
                        "start_line": 68
                    }
                },
                "349": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 12
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.caller": 210,
                            "openzeppelin.account.library.Account_assert_only_self.self": 208,
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 209
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 69,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 69
                    }
                },
                "350": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 12
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.caller": 210,
                            "openzeppelin.account.library.Account_assert_only_self.self": 208,
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 209
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 112,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 68,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 66,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 70,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 70
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 31,
                                        "start_line": 66
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 68
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 112
                    }
                },
                "351": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 13
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_assert_only_self.caller": 210,
                            "openzeppelin.account.library.Account_assert_only_self.self": 208,
                            "openzeppelin.account.library.Account_assert_only_self.syscall_ptr": 209
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 70,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 70
                    }
                },
                "352": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_public_key.pedersen_ptr": 212,
                            "openzeppelin.account.library.Account_get_public_key.range_check_ptr": 213,
                            "openzeppelin.account.library.Account_get_public_key.syscall_ptr": 211
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 78,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 82,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 82
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 78
                    }
                },
                "353": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_public_key.pedersen_ptr": 212,
                            "openzeppelin.account.library.Account_get_public_key.range_check_ptr": 213,
                            "openzeppelin.account.library.Account_get_public_key.syscall_ptr": 211
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 79,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 82,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 82
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 79
                    }
                },
                "354": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_public_key.pedersen_ptr": 212,
                            "openzeppelin.account.library.Account_get_public_key.range_check_ptr": 213,
                            "openzeppelin.account.library.Account_get_public_key.syscall_ptr": 211
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 80,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 82,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 82
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 80
                    }
                },
                "355": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_public_key.pedersen_ptr": 212,
                            "openzeppelin.account.library.Account_get_public_key.range_check_ptr": 213,
                            "openzeppelin.account.library.Account_get_public_key.syscall_ptr": 211
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 17,
                        "start_line": 82
                    }
                },
                "357": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 23
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_public_key.pedersen_ptr": 215,
                            "openzeppelin.account.library.Account_get_public_key.range_check_ptr": 216,
                            "openzeppelin.account.library.Account_get_public_key.res": 217,
                            "openzeppelin.account.library.Account_get_public_key.syscall_ptr": 214
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 83,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 83
                    }
                },
                "358": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_nonce.pedersen_ptr": 219,
                            "openzeppelin.account.library.Account_get_nonce.range_check_ptr": 220,
                            "openzeppelin.account.library.Account_get_nonce.syscall_ptr": 218
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 91,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 91
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 87
                    }
                },
                "359": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_nonce.pedersen_ptr": 219,
                            "openzeppelin.account.library.Account_get_nonce.range_check_ptr": 220,
                            "openzeppelin.account.library.Account_get_nonce.syscall_ptr": 218
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 88,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 91,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 91
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 88
                    }
                },
                "360": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_nonce.pedersen_ptr": 219,
                            "openzeppelin.account.library.Account_get_nonce.range_check_ptr": 220,
                            "openzeppelin.account.library.Account_get_nonce.syscall_ptr": 218
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 89,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 91,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 91
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 89
                    }
                },
                "361": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_nonce.pedersen_ptr": 219,
                            "openzeppelin.account.library.Account_get_nonce.range_check_ptr": 220,
                            "openzeppelin.account.library.Account_get_nonce.syscall_ptr": 218
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 91,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 17,
                        "start_line": 91
                    }
                },
                "363": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 23
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_get_nonce.pedersen_ptr": 222,
                            "openzeppelin.account.library.Account_get_nonce.range_check_ptr": 223,
                            "openzeppelin.account.library.Account_get_nonce.res": 224,
                            "openzeppelin.account.library.Account_get_nonce.syscall_ptr": 221
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 92,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 92
                    }
                },
                "364": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 226
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 50,
                                "end_line": 66,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 31,
                                        "end_line": 104,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 104
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 31,
                                "start_line": 66
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 100
                    }
                },
                "365": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 226
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 104,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 104
                    }
                },
                "367": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 101,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 105,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 105
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 101
                    }
                },
                "368": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 17
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 102,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 105,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 105
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 102
                    }
                },
                "369": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 18
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 103,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 30,
                                "start_line": 105
                            },
                            "While expanding the reference 'new_public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 103
                    }
                },
                "370": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 19
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 227,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 228,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 105,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 105
                    }
                },
                "372": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 37
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_set_public_key.new_public_key": 225,
                            "openzeppelin.account.library.Account_set_public_key.pedersen_ptr": 231,
                            "openzeppelin.account.library.Account_set_public_key.range_check_ptr": 232,
                            "openzeppelin.account.library.Account_set_public_key.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 106,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 106
                    }
                },
                "373": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 235,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 236,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 234
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 19
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 114
                    }
                },
                "374": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 235,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 236,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 234
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 115,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 115
                    }
                },
                "375": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 235,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 236,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 234
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 116,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 116
                    }
                },
                "376": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 235,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 236,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 234
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 117,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 41,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 30,
                                "start_line": 118
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 117
                    }
                },
                "377": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 4
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 235,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 236,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 234
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 118,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 118
                    }
                },
                "379": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 22
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 238,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 239,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 237
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 120,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 31,
                        "start_line": 120
                    }
                },
                "381": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 23
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 238,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 239,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 237
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 120,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 120
                    }
                },
                "383": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_initializer"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 90
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_initializer._public_key": 233,
                            "openzeppelin.account.library.Account_initializer.pedersen_ptr": 241,
                            "openzeppelin.account.library.Account_initializer.range_check_ptr": 242,
                            "openzeppelin.account.library.Account_initializer.syscall_ptr": 240
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 13,
                        "end_line": 121,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 121
                    }
                },
                "384": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 247,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 248,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 246
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 130,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 139,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 139
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 130
                    }
                },
                "385": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 247,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 248,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 246
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 131,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 139,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 139
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 131
                    }
                },
                "386": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 247,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 248,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 246
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 132,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 139,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 139
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 132
                    }
                },
                "387": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 247,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 248,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 246
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 139,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 25,
                        "start_line": 139
                    }
                },
                "389": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 23
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 133,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 151,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 147
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 133
                    }
                },
                "390": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 24
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 135,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 21,
                                "end_line": 148,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 17,
                                "start_line": 148
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 9,
                        "start_line": 135
                    }
                },
                "391": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 25
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 139,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 31,
                                "end_line": 149,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 20,
                                "start_line": 149
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 10,
                        "start_line": 139
                    }
                },
                "392": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 26
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 144,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 150,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 21,
                                "start_line": 150
                            },
                            "While expanding the reference 'sig_r' in:"
                        ],
                        "start_col": 17,
                        "start_line": 144
                    }
                },
                "393": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 27
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 145,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 21,
                                "start_line": 151
                            },
                            "While expanding the reference 'sig_s' in:"
                        ],
                        "start_col": 17,
                        "start_line": 145
                    }
                },
                "394": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 28
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 249,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 151,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 147
                    }
                },
                "396": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 31
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 256,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 50,
                                "end_line": 139,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 130,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 153,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 153
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 130
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 139
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "397": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 32
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 256,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 50,
                                "end_line": 139,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 131,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 153,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 153
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 131
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 139
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "398": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 33
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 256,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 50,
                                "end_line": 139,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 132,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 153,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 153
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 132
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 139
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "399": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 34
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 256,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 7,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 133,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 153,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 153
                                            },
                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 133
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 147
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 29,
                        "start_line": 7
                    }
                },
                "400": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 35
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_is_valid_signature._public_key": 253,
                            "openzeppelin.account.library.Account_is_valid_signature.ecdsa_ptr": 256,
                            "openzeppelin.account.library.Account_is_valid_signature.hash": 243,
                            "openzeppelin.account.library.Account_is_valid_signature.pedersen_ptr": 251,
                            "openzeppelin.account.library.Account_is_valid_signature.range_check_ptr": 252,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_r": 254,
                            "openzeppelin.account.library.Account_is_valid_signature.sig_s": 255,
                            "openzeppelin.account.library.Account_is_valid_signature.signature": 245,
                            "openzeppelin.account.library.Account_is_valid_signature.signature_len": 244,
                            "openzeppelin.account.library.Account_is_valid_signature.syscall_ptr": 250
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 153,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 153
                    }
                },
                "401": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 259,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 132,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 132
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "402": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 259,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 136,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 136
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "403": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 259,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "404": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 136,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 136
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "406": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 136,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 71,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 43,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 136
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "407": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 265,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 26,
                        "start_line": 8
                    }
                },
                "408": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "409": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 132,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 3,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 116,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 32,
                                                                "end_line": 129,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 129
                                                            },
                                                            "While constructing the external wrapper for:"
                                                        ],
                                                        "start_col": 101,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 23,
                                        "start_line": 3
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 132
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "410": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 130,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 130
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "411": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 131,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 131
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "412": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 23,
                        "start_line": 3
                    }
                },
                "414": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 112,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 133,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 137,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 128,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 133
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "415": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 135,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 163,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 144,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_hash' in:"
                                ],
                                "start_col": 9,
                                "start_line": 135
                            },
                            "While handling calldata argument 'hash'"
                        ],
                        "start_col": 27,
                        "start_line": 1
                    }
                },
                "416": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 11
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 136,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 207,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 179,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 136
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "417": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 243,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 219,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature' in:"
                                ],
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 32,
                        "start_line": 5
                    }
                },
                "419": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 260,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 258,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 268,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 129,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 6,
                        "start_line": 129
                    }
                },
                "421": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 32,
                                        "end_line": 129,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 129
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "423": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "424": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "425": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "426": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 54
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 137,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 128,
                        "start_line": 1
                    }
                },
                "427": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 55
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "429": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 56
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 32,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 129
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "430": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library",
                        "__wrappers__",
                        "__wrappers__.Account_is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 57
                        },
                        "reference_ids": {
                            "__wrappers__.Account_is_valid_signature.__calldata_actual_size": 273,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_hash": 262,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature": 269,
                            "__wrappers__.Account_is_valid_signature.__calldata_arg_signature_len": 264,
                            "__wrappers__.Account_is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.Account_is_valid_signature.__temp21": 266,
                            "__wrappers__.Account_is_valid_signature.__temp22": 267,
                            "__wrappers__.Account_is_valid_signature.__temp23": 270,
                            "__wrappers__.Account_is_valid_signature.__temp24": 271,
                            "__wrappers__.Account_is_valid_signature.__temp25": 274,
                            "__wrappers__.Account_is_valid_signature.ecdsa_ptr": 278,
                            "__wrappers__.Account_is_valid_signature.pedersen_ptr": 276,
                            "__wrappers__.Account_is_valid_signature.range_check_ptr": 277,
                            "__wrappers__.Account_is_valid_signature.ret_struct": 279,
                            "__wrappers__.Account_is_valid_signature.retdata": 280,
                            "__wrappers__.Account_is_valid_signature.retdata_size": 281,
                            "__wrappers__.Account_is_valid_signature.syscall_ptr": 275
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/Account_is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 129,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 6,
                                "start_line": 129
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "431": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 287
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 169,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 169
                    }
                },
                "433": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 16
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 287
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 171,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 23,
                        "start_line": 171
                    }
                },
                "435": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 18
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 291,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 287
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 171,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 16,
                                "end_line": 171,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 10,
                                "start_line": 171
                            },
                            "While auto generating local variable for '__fp__'."
                        ],
                        "start_col": 10,
                        "start_line": 171
                    }
                },
                "436": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 18
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 287
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 158,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 344,
                                "input_file": {
                                    "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 172,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 172
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 344
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 158
                    }
                },
                "437": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 19
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 287
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 21,
                        "start_line": 172
                    }
                },
                "439": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 24
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 293,
                            "openzeppelin.account.library.Account_execute.tx_info": 294
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 10,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'tx_info'."
                        ],
                        "start_col": 10,
                        "start_line": 172
                    }
                },
                "440": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 24
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 293,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 344,
                        "input_file": {
                            "filename": "/usr/local/lib/python3.9/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 172
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 344
                    }
                },
                "441": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 25
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 293,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 159,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 173,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 173
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 159
                    }
                },
                "442": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 26
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 293,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 160,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 173,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 173
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 160
                    }
                },
                "443": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 27
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 288,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 289,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 293,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 173,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 28,
                        "start_line": 173
                    }
                },
                "445": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 299,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 297,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 298,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 173,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 10,
                                "start_line": 173
                            },
                            "While auto generating local variable for '_current_nonce'."
                        ],
                        "start_col": 10,
                        "start_line": 173
                    }
                },
                "446": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 297,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 298,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 173
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "447": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 298,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 173
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "448": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 176,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 176
                    }
                },
                "449": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 179,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 27,
                        "start_line": 179
                    }
                },
                "451": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 50
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 303,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 179,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 179,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 10,
                                "start_line": 179
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 10,
                        "start_line": 179
                    }
                },
                "452": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 50
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 319,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 73,
                                                "end_line": 180,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 180
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 30,
                                        "start_line": 319
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 28,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "453": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 51
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 163,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 180,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 29,
                                "start_line": 180
                            },
                            "While expanding the reference 'call_array_len' in:"
                        ],
                        "start_col": 9,
                        "start_line": 163
                    }
                },
                "454": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 52
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 164,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 180,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 45,
                                "start_line": 180
                            },
                            "While expanding the reference 'call_array' in:"
                        ],
                        "start_col": 9,
                        "start_line": 164
                    }
                },
                "455": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 53
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 166,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 180,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 57,
                                "start_line": 180
                            },
                            "While expanding the reference 'calldata' in:"
                        ],
                        "start_col": 9,
                        "start_line": 166
                    }
                },
                "456": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 54
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 179,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 179,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 180,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 67,
                                        "start_line": 180
                                    },
                                    "While expanding the reference 'calls' in:"
                                ],
                                "start_col": 10,
                                "start_line": 179
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 10,
                        "start_line": 179
                    }
                },
                "457": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 55
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 296,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 180,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 180
                    }
                },
                "459": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "460": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "461": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "462": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "463": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "464": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "465": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 35,
                                                        "end_line": 235,
                                                        "input_file": {
                                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 44,
                                                                "end_line": 193,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 18,
                                                                "start_line": 193
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 235
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 173
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "466": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 183,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 193,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 34,
                                "start_line": 193
                            },
                            "While expanding the reference 'multicall' in:"
                        ],
                        "start_col": 11,
                        "start_line": 183
                    }
                },
                "468": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 301,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 305,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 193,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 18,
                        "start_line": 193
                    }
                },
                "470": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 234,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 193,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 130,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 79,
                                                "end_line": 194,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 194
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 130
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 193
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 234
                    }
                },
                "471": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 235,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 193,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 131,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 79,
                                                "end_line": 194,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 194
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 131
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 193
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 235
                    }
                },
                "472": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 24,
                                                        "end_line": 132,
                                                        "input_file": {
                                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 79,
                                                                "end_line": 194,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 194
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 132
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 173
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "473": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 161,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 133,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 79,
                                        "end_line": 194,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 194
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 133
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 161
                    }
                },
                "474": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 4
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 193,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 32,
                                "start_line": 194
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 10,
                        "start_line": 193
                    }
                },
                "475": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 5
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 194,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 38,
                        "start_line": 194
                    }
                },
                "476": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 6
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 78,
                        "end_line": 194,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 61,
                        "start_line": 194
                    }
                },
                "477": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 7
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 290,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 309,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 302,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 308,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 194,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 194
                    }
                },
                "479": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 44
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 314,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 133,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 133,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 79,
                                                "end_line": 194,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 194
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 133
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 194
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 133
                    }
                },
                "480": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 44
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 130,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 35,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 16,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 194
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 130
                    }
                },
                "481": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 45
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 131,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 194
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 131
                    }
                },
                "482": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 46
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 132,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 194
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 132
                    }
                },
                "483": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 47
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 51,
                        "end_line": 197,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 33,
                        "start_line": 197
                    }
                },
                "485": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 48
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 312,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 313,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 311,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 197,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 5,
                        "start_line": 197
                    }
                },
                "487": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 66
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 317,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 318,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 52,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 197
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "488": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 66
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 318,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 52,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 197
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "489": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 66
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 200,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 30,
                        "start_line": 200
                    }
                },
                "491": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 69
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 321,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 200,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 200,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 10,
                                "start_line": 200
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 10,
                        "start_line": 200
                    }
                },
                "492": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 69
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 52,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 206,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 86,
                                                "end_line": 201,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 26,
                                                "start_line": 201
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 19,
                                        "start_line": 206
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 197
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 19
                    }
                },
                "493": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 70
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 39,
                        "start_line": 201
                    }
                },
                "494": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 71
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 60,
                        "start_line": 201
                    }
                },
                "495": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 72
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 200,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 200,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 85,
                                        "end_line": 201,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 77,
                                        "start_line": 201
                                    },
                                    "While expanding the reference 'response' in:"
                                ],
                                "start_col": 10,
                                "start_line": 200
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 10,
                        "start_line": 200
                    }
                },
                "496": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 73
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 316,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 201
                    }
                },
                "498": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 0
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 206,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 201,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 158,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 58,
                                                "end_line": 203,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 203
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 158
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 26,
                                "start_line": 201
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 206
                    }
                },
                "499": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 1
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 52,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 36,
                                                        "end_line": 159,
                                                        "input_file": {
                                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 58,
                                                                "end_line": 203,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 203
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 159
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 197
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "500": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 2
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 52,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 52,
                                                "end_line": 197,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 24,
                                                        "end_line": 160,
                                                        "input_file": {
                                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 58,
                                                                "end_line": 203,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 203
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 160
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 197
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 197
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "501": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 3
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 133,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 133,
                                        "input_file": {
                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 79,
                                                "end_line": 194,
                                                "input_file": {
                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 37,
                                                        "end_line": 161,
                                                        "input_file": {
                                                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 58,
                                                                "end_line": 203,
                                                                "input_file": {
                                                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 203
                                                            },
                                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 161
                                                    },
                                                    "While expanding the reference 'ecdsa_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 194
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 133
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 194
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 133
                    }
                },
                "502": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 4
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 203,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },
                                "start_col": 26,
                                "start_line": 203
                            },
                            "While expanding the reference 'response_len' in:"
                        ],
                        "start_col": 10,
                        "start_line": 201
                    }
                },
                "503": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 41,
                            "offset": 5
                        },
                        "reference_ids": {
                            "openzeppelin.account.library.Account_execute.__fp__": 292,
                            "openzeppelin.account.library.Account_execute._current_nonce": 300,
                            "openzeppelin.account.library.Account_execute.call_array": 283,
                            "openzeppelin.account.library.Account_execute.call_array_len": 282,
                            "openzeppelin.account.library.Account_execute.calldata": 285,
                            "openzeppelin.account.library.Account_execute.calldata_len": 284,
                            "openzeppelin.account.library.Account_execute.calls": 304,
                            "openzeppelin.account.library.Account_execute.calls_len": 306,
                            "openzeppelin.account.library.Account_execute.ecdsa_ptr": 315,
                            "openzeppelin.account.library.Account_execute.hash": 310,
                            "openzeppelin.account.library.Account_execute.multicall": 307,
                            "openzeppelin.account.library.Account_execute.nonce": 286,
                            "openzeppelin.account.library.Account_execute.pedersen_ptr": 319,
                            "openzeppelin.account.library.Account_execute.range_check_ptr": 320,
                            "openzeppelin.account.library.Account_execute.response": 322,
                            "openzeppelin.account.library.Account_execute.response_len": 324,
                            "openzeppelin.account.library.Account_execute.syscall_ptr": 323,
                            "openzeppelin.account.library.Account_execute.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 200,
                        "input_file": {
                            "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 200,
                                "input_file": {
                                    "filename": "/Users/maksymiliandemitraszek/Projects/StarkWare/cairo-contracts/openzeppelin/account/library.cairo"
                                },