# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemAaaProfileParcelArgs', 'SystemAaaProfileParcel']

@pulumi.input_type
class SystemAaaProfileParcelArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 server_auth_orders: pulumi.Input[Sequence[pulumi.Input[str]]],
                 accounting_group: Optional[pulumi.Input[bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]] = None,
                 authentication_group: Optional[pulumi.Input[bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[str]] = None,
                 authorization_console: Optional[pulumi.Input[bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]] = None):
        """
        The set of arguments for constructing a SystemAaaProfileParcel resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[str] authentication_group_variable: Variable name
        :param pulumi.Input[bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]] users: Create local login account
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "server_auth_orders", server_auth_orders)
        if accounting_group is not None:
            pulumi.set(__self__, "accounting_group", accounting_group)
        if accounting_group_variable is not None:
            pulumi.set(__self__, "accounting_group_variable", accounting_group_variable)
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authentication_group is not None:
            pulumi.set(__self__, "authentication_group", authentication_group)
        if authentication_group_variable is not None:
            pulumi.set(__self__, "authentication_group_variable", authentication_group_variable)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_groups is not None:
            pulumi.set(__self__, "radius_groups", radius_groups)
        if tacacs_groups is not None:
            pulumi.set(__self__, "tacacs_groups", tacacs_groups)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @server_auth_orders.setter
    def server_auth_orders(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "server_auth_orders", value)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @accounting_group.setter
    def accounting_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accounting_group", value)

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @accounting_group_variable.setter
    def accounting_group_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accounting_group_variable", value)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @authentication_group.setter
    def authentication_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authentication_group", value)

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @authentication_group_variable.setter
    def authentication_group_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_group_variable", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @radius_groups.setter
    def radius_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]]):
        pulumi.set(self, "radius_groups", value)

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @tacacs_groups.setter
    def tacacs_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]]):
        pulumi.set(self, "tacacs_groups", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _SystemAaaProfileParcelState:
    def __init__(__self__, *,
                 accounting_group: Optional[pulumi.Input[bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]] = None,
                 authentication_group: Optional[pulumi.Input[bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[str]] = None,
                 authorization_console: Optional[pulumi.Input[bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SystemAaaProfileParcel resources.
        :param pulumi.Input[bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[str] authentication_group_variable: Variable name
        :param pulumi.Input[bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]] users: Create local login account
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        if accounting_group is not None:
            pulumi.set(__self__, "accounting_group", accounting_group)
        if accounting_group_variable is not None:
            pulumi.set(__self__, "accounting_group_variable", accounting_group_variable)
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authentication_group is not None:
            pulumi.set(__self__, "authentication_group", authentication_group)
        if authentication_group_variable is not None:
            pulumi.set(__self__, "authentication_group_variable", authentication_group_variable)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_groups is not None:
            pulumi.set(__self__, "radius_groups", radius_groups)
        if server_auth_orders is not None:
            pulumi.set(__self__, "server_auth_orders", server_auth_orders)
        if tacacs_groups is not None:
            pulumi.set(__self__, "tacacs_groups", tacacs_groups)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @accounting_group.setter
    def accounting_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accounting_group", value)

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @accounting_group_variable.setter
    def accounting_group_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accounting_group_variable", value)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @authentication_group.setter
    def authentication_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authentication_group", value)

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @authentication_group_variable.setter
    def authentication_group_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_group_variable", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @radius_groups.setter
    def radius_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelRadiusGroupArgs']]]]):
        pulumi.set(self, "radius_groups", value)

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @server_auth_orders.setter
    def server_auth_orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_auth_orders", value)

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @tacacs_groups.setter
    def tacacs_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelTacacsGroupArgs']]]]):
        pulumi.set(self, "tacacs_groups", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaProfileParcelUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class SystemAaaProfileParcel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_group: Optional[pulumi.Input[bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAccountingRuleArgs']]]]] = None,
                 authentication_group: Optional[pulumi.Input[bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[str]] = None,
                 authorization_console: Optional[pulumi.Input[bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAuthorizationRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelRadiusGroupArgs']]]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelTacacsGroupArgs']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelUserArgs']]]]] = None,
                 __props__=None):
        """
        This resource can manage a System AAA profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemAaaProfileParcel:SystemAaaProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAccountingRuleArgs']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[str] authentication_group_variable: Variable name
        :param pulumi.Input[bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAuthorizationRuleArgs']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelRadiusGroupArgs']]]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelTacacsGroupArgs']]]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelUserArgs']]]] users: Create local login account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemAaaProfileParcelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System AAA profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemAaaProfileParcel:SystemAaaProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SystemAaaProfileParcelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemAaaProfileParcelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_group: Optional[pulumi.Input[bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAccountingRuleArgs']]]]] = None,
                 authentication_group: Optional[pulumi.Input[bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[str]] = None,
                 authorization_console: Optional[pulumi.Input[bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAuthorizationRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelRadiusGroupArgs']]]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelTacacsGroupArgs']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelUserArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemAaaProfileParcelArgs.__new__(SystemAaaProfileParcelArgs)

            __props__.__dict__["accounting_group"] = accounting_group
            __props__.__dict__["accounting_group_variable"] = accounting_group_variable
            __props__.__dict__["accounting_rules"] = accounting_rules
            __props__.__dict__["authentication_group"] = authentication_group
            __props__.__dict__["authentication_group_variable"] = authentication_group_variable
            __props__.__dict__["authorization_config_commands"] = authorization_config_commands
            __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
            __props__.__dict__["authorization_console"] = authorization_console
            __props__.__dict__["authorization_console_variable"] = authorization_console_variable
            __props__.__dict__["authorization_rules"] = authorization_rules
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["radius_groups"] = radius_groups
            if server_auth_orders is None and not opts.urn:
                raise TypeError("Missing required property 'server_auth_orders'")
            __props__.__dict__["server_auth_orders"] = server_auth_orders
            __props__.__dict__["tacacs_groups"] = tacacs_groups
            __props__.__dict__["users"] = users
            __props__.__dict__["version"] = None
        super(SystemAaaProfileParcel, __self__).__init__(
            'sdwan:index/systemAaaProfileParcel:SystemAaaProfileParcel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounting_group: Optional[pulumi.Input[bool]] = None,
            accounting_group_variable: Optional[pulumi.Input[str]] = None,
            accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAccountingRuleArgs']]]]] = None,
            authentication_group: Optional[pulumi.Input[bool]] = None,
            authentication_group_variable: Optional[pulumi.Input[str]] = None,
            authorization_config_commands: Optional[pulumi.Input[bool]] = None,
            authorization_config_commands_variable: Optional[pulumi.Input[str]] = None,
            authorization_console: Optional[pulumi.Input[bool]] = None,
            authorization_console_variable: Optional[pulumi.Input[str]] = None,
            authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAuthorizationRuleArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelRadiusGroupArgs']]]]] = None,
            server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelTacacsGroupArgs']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelUserArgs']]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'SystemAaaProfileParcel':
        """
        Get an existing SystemAaaProfileParcel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAccountingRuleArgs']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[str] authentication_group_variable: Variable name
        :param pulumi.Input[bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelAuthorizationRuleArgs']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelRadiusGroupArgs']]]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelTacacsGroupArgs']]]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SystemAaaProfileParcelUserArgs']]]] users: Create local login account
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemAaaProfileParcelState.__new__(_SystemAaaProfileParcelState)

        __props__.__dict__["accounting_group"] = accounting_group
        __props__.__dict__["accounting_group_variable"] = accounting_group_variable
        __props__.__dict__["accounting_rules"] = accounting_rules
        __props__.__dict__["authentication_group"] = authentication_group
        __props__.__dict__["authentication_group_variable"] = authentication_group_variable
        __props__.__dict__["authorization_config_commands"] = authorization_config_commands
        __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
        __props__.__dict__["authorization_console"] = authorization_console
        __props__.__dict__["authorization_console_variable"] = authorization_console_variable
        __props__.__dict__["authorization_rules"] = authorization_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["radius_groups"] = radius_groups
        __props__.__dict__["server_auth_orders"] = server_auth_orders
        __props__.__dict__["tacacs_groups"] = tacacs_groups
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return SystemAaaProfileParcel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> pulumi.Output[Optional[bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaProfileParcelAccountingRule']]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> pulumi.Output[Optional[bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> pulumi.Output[Optional[bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> pulumi.Output[Optional[bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaProfileParcelAuthorizationRule']]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaProfileParcelRadiusGroup']]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> pulumi.Output[Sequence[str]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaProfileParcelTacacsGroup']]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaProfileParcelUser']]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

