# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .sanctions_details_entity_type import SanctionsDetailsEntityType
from .sanctions_screening_entity import SanctionsScreeningEntity

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SanctionsHitContext(pydantic.BaseModel):
    entity: typing.Optional[SanctionsScreeningEntity]
    entity_type: typing.Optional[SanctionsDetailsEntityType] = pydantic.Field(alias="entityType")
    user_id: typing.Optional[str] = pydantic.Field(alias="userId")
    transaction_id: typing.Optional[str] = pydantic.Field(alias="transactionId")
    rule_instance_id: typing.Optional[str] = pydantic.Field(alias="ruleInstanceId")
    iban: typing.Optional[str]
    year_of_birth: typing.Optional[float] = pydantic.Field(alias="yearOfBirth")
    search_term: typing.Optional[str] = pydantic.Field(alias="searchTerm")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
